/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icons.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.teamapps.icons.IconResource;
import org.teamapps.icons.IconType;
import org.teamapps.icons.cache.IconCache;

public class FileIconCache
implements IconCache {
    private final File cacheDirectory;
    private final Map<EncodedIconStringAndSize, File> cachedFilesByEncodedIconString = new ConcurrentHashMap<EncodedIconStringAndSize, File>();

    public FileIconCache() {
        try {
            this.cacheDirectory = File.createTempFile("icon-cache", "temp").getParentFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FileIconCache(File cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    @Override
    public IconResource getIcon(String encodedIconString, int size) {
        File file = this.cachedFilesByEncodedIconString.get(new EncodedIconStringAndSize(encodedIconString, size));
        return file != null ? FileIconCache.readFromFile(file) : null;
    }

    @Override
    public void putIcon(String encodedIconString, int size, IconResource iconResource) {
        if (iconResource == null || iconResource.getBytes().length == 0) {
            return;
        }
        File file = new File(this.cacheDirectory, UUID.randomUUID().toString());
        this.writeToFile(iconResource, file);
        this.cachedFilesByEncodedIconString.put(new EncodedIconStringAndSize(encodedIconString, size), file);
    }

    private static IconResource readFromFile(File file) {
        if (file.exists()) {
            try {
                FileInputStream inputStream = new FileInputStream(file);
                int typeLength = inputStream.read();
                String typeString = new String(inputStream.readNBytes(typeLength), StandardCharsets.US_ASCII);
                IconType iconType = IconType.valueOf(typeString);
                byte[] iconBytes = IOUtils.toByteArray((InputStream)inputStream);
                return new IconResource(iconBytes, iconType);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private boolean writeToFile(IconResource iconResource, File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(iconResource.getIconType().name().length());
            fos.write(iconResource.getIconType().name().getBytes(StandardCharsets.US_ASCII));
            fos.write(iconResource.getBytes());
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(0xFF & hash[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private static class EncodedIconStringAndSize {
        String encodedIconString;
        int size;

        public EncodedIconStringAndSize(String encodedIconString, int size) {
            this.encodedIconString = encodedIconString;
            this.size = size;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EncodedIconStringAndSize that = (EncodedIconStringAndSize)o;
            return this.size == that.size && Objects.equals(this.encodedIconString, that.encodedIconString);
        }

        public int hashCode() {
            return Objects.hash(this.encodedIconString, this.size);
        }
    }
}

