/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icons;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.icons.Icon;
import org.teamapps.icons.spi.DefaultStyleSupplier;
import org.teamapps.icons.spi.IconDecoder;
import org.teamapps.icons.spi.IconEncoder;
import org.teamapps.icons.spi.IconLibrary;
import org.teamapps.icons.spi.IconLoader;

public class IconLibraryRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<Class<? extends Icon<?, ?>>, String> libraryNameByIconClass = new HashMap();
    private final Map<String, IconEncoder> encodersByLibraryName = new HashMap<String, IconEncoder>();
    private final Map<String, IconDecoder> decodersByLibraryName = new HashMap<String, IconDecoder>();
    private final Map<String, IconLoader> loadersByLibraryName = new HashMap<String, IconLoader>();
    private final Map<String, Object> defaultIconStylesByLibraryName = new HashMap<String, Object>();

    public <I extends Icon<I, S>, S> IconEncoder<I> getIconEncoder(Class<I> iconClass) {
        this.registerIconLibrary(iconClass);
        String libraryName = this.libraryNameByIconClass.get(iconClass);
        return this.encodersByLibraryName.get(libraryName);
    }

    public <I extends Icon<I, S>, S> IconDecoder<I> getIconDecoder(String libraryName) {
        return this.decodersByLibraryName.get(libraryName);
    }

    public <I extends Icon<I, S>, S> IconLoader<I> getIconLoader(String libraryName) {
        return this.loadersByLibraryName.get(libraryName);
    }

    public <S, I extends Icon<I, S>> S getDefaultStyle(Class<I> iconClass) {
        return (S)this.defaultIconStylesByLibraryName.get(this.getLibraryName(iconClass));
    }

    public String getLibraryName(Icon<?, ?> icon) {
        return this.getLibraryName(icon.getClass());
    }

    public <I extends Icon<I, S>, S> String getLibraryName(Class<I> iconClass) {
        this.registerIconLibrary(iconClass);
        return this.libraryNameByIconClass.get(iconClass);
    }

    public <I extends Icon<I, S>, S> void registerIconLibrary(Class<I> iconClass) {
        IconLibrary libraryAnnotation;
        if (!this.libraryNameByIconClass.containsKey(iconClass) && (libraryAnnotation = IconLibraryRegistry.findAnnotation(iconClass, IconLibrary.class)) != null) {
            DefaultStyleSupplier defaultStyleSupplier;
            IconLoader iconLoader;
            IconDecoder iconDecoder;
            IconEncoder iconEncoder;
            try {
                iconEncoder = libraryAnnotation.encoder().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Could not create icon encoder for icon class " + String.valueOf(iconClass), (Throwable)e);
                throw new RuntimeException(e);
            }
            try {
                iconDecoder = libraryAnnotation.decoder().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Could not create icon decoder for icon class " + String.valueOf(iconClass), (Throwable)e);
                throw new RuntimeException(e);
            }
            try {
                iconLoader = libraryAnnotation.loader().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Could not create icon loader for icon class " + String.valueOf(iconClass), (Throwable)e);
                throw new RuntimeException(e);
            }
            try {
                defaultStyleSupplier = libraryAnnotation.defaultStyleSupplier().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Could not create defaultStyleSupplier for icon class " + String.valueOf(iconClass), (Throwable)e);
                throw new RuntimeException(e);
            }
            this.registerIconLibrary(iconClass, libraryAnnotation.name(), iconEncoder, iconDecoder, iconLoader, defaultStyleSupplier.getDefaultStyle());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <I extends Icon<I, S>, S> void registerIconLibrary(Class<I> iconClass, String libraryName, IconEncoder<I> iconEncoder, IconDecoder<I> iconDecoder, IconLoader<I> iconLoader, S defaultStyle) {
        IconLibraryRegistry iconLibraryRegistry = this;
        synchronized (iconLibraryRegistry) {
            if (!this.libraryNameByIconClass.containsKey(iconClass)) {
                this.libraryNameByIconClass.put(iconClass, libraryName);
                this.encodersByLibraryName.put(libraryName, iconEncoder);
                this.decodersByLibraryName.put(libraryName, iconDecoder);
                this.loadersByLibraryName.put(libraryName, iconLoader);
                this.defaultIconStylesByLibraryName.put(libraryName, defaultStyle);
            }
        }
    }

    private static <A extends Annotation> A findAnnotation(Class<?> clazz, Class<A> annotationClass) {
        A annotation = clazz.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        return (A)Arrays.stream(clazz.getInterfaces()).map(i -> IconLibraryRegistry.findAnnotation(i, annotationClass)).filter(Objects::nonNull).findFirst().orElseGet(() -> IconLibraryRegistry.findAnnotation(clazz.getSuperclass(), annotationClass));
    }
}

