/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icons.systemprovider;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import org.teamapps.icons.systemprovider.IconUtils;

public class CompositeIconProvider {
    public byte[] createComposedIcon(int size, byte[] baseIcon, byte[] bottomRight, byte[] bottomLeft, byte[] topLeft, byte[] topRight) {
        try {
            BufferedImage subIcon;
            BufferedImage image = ImageIO.read(IconUtils.getInputStream(baseIcon));
            if (bottomRight != null) {
                subIcon = ImageIO.read(IconUtils.getInputStream(bottomRight));
                image = Thumbnails.of((BufferedImage[])new BufferedImage[]{image}).size(size, size).watermark((Position)Positions.BOTTOM_RIGHT, subIcon, 1.0f).asBufferedImage();
            }
            if (bottomLeft != null) {
                subIcon = ImageIO.read(IconUtils.getInputStream(bottomLeft));
                image = Thumbnails.of((BufferedImage[])new BufferedImage[]{image}).size(size, size).watermark((Position)Positions.BOTTOM_LEFT, subIcon, 1.0f).asBufferedImage();
            }
            if (topLeft != null) {
                subIcon = ImageIO.read(IconUtils.getInputStream(topLeft));
                image = Thumbnails.of((BufferedImage[])new BufferedImage[]{image}).size(size, size).watermark((Position)Positions.TOP_LEFT, subIcon, 1.0f).asBufferedImage();
            }
            if (topRight != null) {
                subIcon = ImageIO.read(IconUtils.getInputStream(topRight));
                image = Thumbnails.of((BufferedImage[])new BufferedImage[]{image}).size(size, size).watermark((Position)Positions.TOP_RIGHT, subIcon, 1.0f).asBufferedImage();
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Thumbnails.of((BufferedImage[])new BufferedImage[]{image}).size(size, size).outputFormat("PNG").toOutputStream((OutputStream)bos);
            return bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

