/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icons.api;

import org.teamapps.icons.api.IconTheme;
import org.teamapps.icons.api.SimpleIcon;

public class StyledIcon
implements SimpleIcon {
    private String iconLibraryId;
    private String styleId;
    private String iconName;

    public static StyledIcon parseIcon(String styledIconId) {
        String[] parts = styledIconId.split("\\.");
        String iconLibraryId = parts[0];
        String styleId = parts[1];
        int pos = iconLibraryId.length() + ".".length() + styleId.length() + ".".length();
        String iconName = styledIconId.substring(pos);
        return new StyledIcon(iconLibraryId, styleId, iconName);
    }

    public StyledIcon(String iconLibraryId, String styleId, String iconName) {
        this.iconLibraryId = iconLibraryId;
        this.styleId = styleId;
        this.iconName = iconName;
    }

    @Override
    public String getIconName() {
        return this.iconName;
    }

    @Override
    public String getIconLibraryId() {
        return this.iconLibraryId;
    }

    public String getStyleId() {
        return this.styleId;
    }

    @Override
    public String getQualifiedIconId(IconTheme theme, boolean baseStyle) {
        return this.getQualifiedIconId();
    }

    public String getQualifiedIconId() {
        return this.getIconLibraryId() + "." + this.styleId + "." + this.getIconName();
    }

    public String toString() {
        return "StyledIcon{iconLibraryId='" + this.iconLibraryId + "', styleId='" + this.styleId + "', iconName='" + this.iconName + "'}";
    }
}

