/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icons.api;

import org.teamapps.icons.api.Icon;
import org.teamapps.icons.api.IconTheme;

public class CompositeIcon
implements Icon {
    public static final String COMPOSED_ICON_PREFIX = "x-multi-icon.";
    public static final String SUB_ICON_MARKER = ".x-sub-";
    public static final String BOTTOM_RIGHT_SUB_ICON = ".x-sub-1.";
    public static final String BOTTOM_LEFT_SUB_ICON = ".x-sub-2.";
    public static final String TOP_LEFT_SUB_ICON = ".x-sub-3.";
    public static final String TOP_RIGHT_SUB_ICON = ".x-sub-4.";
    private Icon baseIcon;
    private Icon bottomRightIcon;
    private Icon bottomLeftIcon;
    private Icon topLeftIcon;
    private Icon topRightIcon;

    public static CompositeIcon of(Icon baseIcon, Icon bottomRightIcon) {
        return new CompositeIcon(baseIcon, bottomRightIcon);
    }

    public static CompositeIcon of(Icon baseIcon, Icon bottomRightIcon, Icon bottomLeftIcon, Icon topLeftIcon, Icon topRightIcon) {
        return new CompositeIcon(baseIcon, bottomRightIcon, bottomLeftIcon, topLeftIcon, topRightIcon);
    }

    public CompositeIcon(Icon baseIcon) {
        this.baseIcon = baseIcon;
    }

    public CompositeIcon(Icon baseIcon, Icon bottomRightIcon) {
        this.baseIcon = baseIcon;
        this.bottomRightIcon = bottomRightIcon;
    }

    public CompositeIcon(Icon baseIcon, Icon bottomRightIcon, Icon bottomLeftIcon, Icon topLeftIcon, Icon topRightIcon) {
        this.baseIcon = baseIcon;
        this.bottomRightIcon = bottomRightIcon;
        this.bottomLeftIcon = bottomLeftIcon;
        this.topLeftIcon = topLeftIcon;
        this.topRightIcon = topRightIcon;
    }

    @Override
    public String getQualifiedIconId(IconTheme theme, boolean baseStyle) {
        StringBuilder sb = new StringBuilder();
        sb.append(COMPOSED_ICON_PREFIX);
        sb.append(this.baseIcon.getQualifiedIconId(theme, baseStyle));
        if (this.bottomRightIcon != null) {
            sb.append(BOTTOM_RIGHT_SUB_ICON);
            sb.append(this.bottomRightIcon.getQualifiedIconId(theme, false));
        }
        if (this.bottomLeftIcon != null) {
            sb.append(BOTTOM_LEFT_SUB_ICON);
            sb.append(this.bottomLeftIcon.getQualifiedIconId(theme, false));
        }
        if (this.topLeftIcon != null) {
            sb.append(TOP_LEFT_SUB_ICON);
            sb.append(this.topLeftIcon.getQualifiedIconId(theme, false));
        }
        if (this.topRightIcon != null) {
            sb.append(TOP_RIGHT_SUB_ICON);
            sb.append(this.topRightIcon.getQualifiedIconId(theme, false));
        }
        return sb.toString();
    }
}

