/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icon.material;

import java.util.ArrayList;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icon.material.MaterialIconStyle;
import org.teamapps.icon.material.MaterialIconStyleType;
import org.teamapps.icons.IconDecoderContext;
import org.teamapps.icons.spi.IconDecoder;

public class MaterialIconDecoder
implements IconDecoder<MaterialIcon> {
    public MaterialIcon decodeIcon(String encodedIconString, IconDecoderContext context) {
        String[] parts = encodedIconString.split("\\.");
        String iconName = parts[0];
        if (parts.length == 1) {
            return MaterialIcon.forName(iconName);
        }
        MaterialIconStyleType styleType = MaterialIconStyleType.valueOf(parts[1]);
        ArrayList<String> colors = new ArrayList<String>();
        for (int i = 2; i < parts.length; ++i) {
            if (parts[i].length() <= 0) continue;
            colors.add(parts[i]);
        }
        MaterialIconStyle style = new MaterialIconStyle(styleType, (String[])colors.toArray(String[]::new));
        return MaterialIcon.forName(iconName).withStyle(style);
    }
}

