/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icon.material;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icon.material.MaterialIconStyle;
import org.teamapps.icons.IconLoaderContext;
import org.teamapps.icons.IconResource;
import org.teamapps.icons.IconType;
import org.teamapps.icons.spi.IconLoader;

public class MaterialIconLoader
implements IconLoader<MaterialIcon> {
    public IconResource loadIcon(MaterialIcon icon, int size, IconLoaderContext context) {
        return new IconResource(this.getSVG(icon.getIconName(), icon.getStyle()), IconType.SVG);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getSVG(String iconName, MaterialIconStyle style) {
        if (!((String)iconName).endsWith(".svg")) {
            iconName = (String)iconName + ".svg";
        }
        try (InputStream inputStream = this.getClass().getResourceAsStream("/org/teamapps/icon/material/" + style.getStyleType().getPackageName() + "/" + (String)iconName);){
            if (inputStream == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            String svg = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            svg = svg.replace("<desc>add icon - Licensed under Apache License v2.0 (http://www.apache.org/licenses/LICENSE-2.0) - Created with Iconfu.com - Derivative work of Material icons (Copyright Google Inc.)</desc>", "");
            svg = style.applyStyle(svg);
            byte[] byArray = svg.getBytes(StandardCharsets.UTF_8);
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

