/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icon.material;

import org.teamapps.icon.material.StyleType;
import org.teamapps.icons.api.IconStyle;

public abstract class AbstractMaterialIconStyle
implements IconStyle {
    private final String styleId;
    private final StyleType styleType;
    private String styleName;
    private boolean canBeUsedAsSubIcon;

    public AbstractMaterialIconStyle(String styleId, StyleType styleType) {
        this.styleId = styleId;
        this.styleType = styleType;
    }

    public AbstractMaterialIconStyle(String styleId, StyleType styleType, String styleName, boolean canBeUsedAsSubIcon) {
        this.styleId = styleId;
        this.styleType = styleType;
        this.styleName = styleName;
        this.canBeUsedAsSubIcon = canBeUsedAsSubIcon;
    }

    public void setStyleName(String styleName) {
        this.styleName = styleName;
    }

    public void setCanBeUsedAsSubIcon(boolean canBeUsedAsSubIcon) {
        this.canBeUsedAsSubIcon = canBeUsedAsSubIcon;
    }

    public StyleType getStyleType() {
        return this.styleType;
    }

    public String getStyleId() {
        return this.styleId;
    }

    public String getStyleName() {
        return this.styleName;
    }

    public boolean canBeUsedAsSubIcon() {
        return this.canBeUsedAsSubIcon;
    }

    public abstract String applyStyle(String var1);

    public String applyStyle(String svg, String styleTags) {
        int pos = svg.indexOf(62);
        return svg.substring(0, pos + 2) + styleTags + svg.substring(pos + 1, svg.length());
    }

    public String createStyleTags(String ... colors) {
        StringBuilder sb = new StringBuilder("<style>\n");
        for (int i = 1; i <= colors.length; ++i) {
            sb.append(".teamapps-color-").append(i).append(" {").append("color:").append(colors[i - 1]).append("}");
        }
        sb.append("\n</style>");
        return sb.toString();
    }
}

