/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icon.material;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.teamapps.icon.material.AbstractMaterialIconStyle;
import org.teamapps.icon.material.GradientStyle;
import org.teamapps.icon.material.MaterialIconStyles;
import org.teamapps.icon.material.OutlineFilledStyle;
import org.teamapps.icon.material.OutlineStyle;
import org.teamapps.icon.material.PlainShadowStyle;
import org.teamapps.icon.material.PlainStyle;
import org.teamapps.icons.api.IconStyle;
import org.teamapps.icons.provider.SvgIconProvider;

public class MaterialIconProvider
implements SvgIconProvider<IconStyle> {
    public static final String LIBRARY_ID = "material";
    private final Map<String, AbstractMaterialIconStyle> styleById = new HashMap<String, AbstractMaterialIconStyle>();
    private final Map<String, String> svgByStyleAndName = new HashMap<String, String>();

    public MaterialIconProvider() {
        MaterialIconStyles.getBaseStyles().forEach(this::addIconStyle);
    }

    public void addIconStyle(AbstractMaterialIconStyle iconStyle) {
        this.styleById.put(iconStyle.getStyleId(), iconStyle);
    }

    public void addPlainStyle(String styleId, String color) {
        this.addIconStyle(new PlainStyle(styleId, color));
    }

    public void addPlainShadowStyle(String styleId, String color) {
        this.addIconStyle(new PlainShadowStyle(styleId, color));
    }

    public void addOutlineStyle(String styleId, String color) {
        this.addIconStyle(new OutlineStyle(styleId, color));
    }

    public void addOutlineFilledStyle(String styleId, String color) {
        this.addIconStyle(new OutlineFilledStyle(styleId, color));
    }

    public void addGradientStyle(String styleId, String color1, String color2, String color3) {
        this.addIconStyle(new GradientStyle(styleId, color1, color2, color3));
    }

    public String getInnerSvg(IconStyle style, String iconName) {
        String svg = this.getSVG(style.getStyleId(), iconName);
        if (svg != null) {
            // empty if block
        }
        return null;
    }

    public byte[] getIcon(String styleId, int size, String iconName) {
        String svg = this.getSVG(styleId, iconName);
        if (svg != null) {
            return svg.getBytes(StandardCharsets.UTF_8);
        }
        return null;
    }

    private String getSVG(String styleId, String iconName) {
        InputStream inputStream;
        String key;
        String svg;
        if (!((String)iconName).endsWith(".svg")) {
            iconName = (String)iconName + ".svg";
        }
        if ((svg = this.svgByStyleAndName.get(key = styleId + ":" + (String)iconName)) != null) {
            return svg;
        }
        AbstractMaterialIconStyle iconStyle = this.styleById.get(styleId);
        if (iconStyle == null) {
            iconStyle = MaterialIconStyles.PLAIN_SHADOW_BLUE_700;
        }
        if ((inputStream = this.getClass().getResourceAsStream("/org/teamapps/icon/material/" + iconStyle.getStyleType().getPackageName() + "/" + (String)iconName)) == null) {
            return null;
        }
        try {
            svg = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            svg = svg.replace("<desc>add icon - Licensed under Apache License v2.0 (http://www.apache.org/licenses/LICENSE-2.0) - Created with Iconfu.com - Derivative work of Material icons (Copyright Google Inc.)</desc>", "");
            svg = iconStyle.applyStyle(svg);
            this.svgByStyleAndName.put(key, svg);
            return svg;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getIconLibraryId() {
        return LIBRARY_ID;
    }

    public Set<Integer> getAvailableIconSizes() {
        return null;
    }

    public Set<IconStyle> getAvailableIconStyles() {
        return new HashSet<IconStyle>(this.styleById.values());
    }

    public IconStyle getDefaultDesktopStyle() {
        return MaterialIconStyles.PLAIN_SHADOW_BLUE_700;
    }

    public IconStyle getDefaultMobileStyle() {
        return MaterialIconStyles.PLAIN_SHADOW_BLUE_700;
    }

    public IconStyle getDefaultSubIconStyle() {
        return MaterialIconStyles.PLAIN_SHADOW_BLUE_700;
    }
}

