/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icon.material;

import java.util.Arrays;
import org.teamapps.common.format.Color;
import org.teamapps.icon.material.MaterialIconStyleType;

public class MaterialIconStyle {
    private final MaterialIconStyleType styleType;
    private final String[] colors;

    public MaterialIconStyle(MaterialIconStyleType styleType, String ... colors) {
        this.styleType = styleType;
        this.colors = colors;
    }

    public MaterialIconStyle(MaterialIconStyleType styleType, Color ... colors) {
        this.styleType = styleType;
        this.colors = (String[])Arrays.stream(colors).map(Color::toHtmlColorString).toArray(String[]::new);
    }

    public MaterialIconStyleType getStyleType() {
        return this.styleType;
    }

    public String[] getColors() {
        return this.colors;
    }

    public String applyStyle(String svg) {
        String styleTags = this.createStyleTags(this.colors);
        return this.applyStyle(svg, styleTags);
    }

    private String applyStyle(String svg, String styleTags) {
        int pos = svg.indexOf(62);
        return svg.substring(0, pos + 2) + styleTags + svg.substring(pos + 1);
    }

    private String createStyleTags(String ... colors) {
        StringBuilder sb = new StringBuilder("<style>\n");
        for (int i = 1; i <= colors.length; ++i) {
            sb.append(".teamapps-color-").append(i).append(" {").append("color:").append(colors[i - 1]).append("}");
        }
        sb.append("\n</style>");
        return sb.toString();
    }
}

