/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.media.exec;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;

public enum ExternalResource {
    YOUTUBE_DOWNLOADER(true, "youtube/youtube-dl", "youtube/youtube-dl", "youtube/youtube-dl.exe"),
    FFMPEG(true, "ffmpeg/ffmpeg-linux", "ffmpeg/ffmpeg-osx", "ffmpeg/ffmpeg.exe"),
    FFPROBE(true, "ffprobe/ffprobe-linux", "ffprobe/ffprobe-osx", "ffprobe/ffprobe.exe");

    private boolean executable;
    private String linuxResource;
    private String osxResource;
    private String windowsResource;

    private ExternalResource(boolean executable, String linuxResource, String osxResource, String windowsResource) {
        this.executable = executable;
        this.linuxResource = linuxResource;
        this.osxResource = osxResource;
        this.windowsResource = windowsResource;
    }

    private ExternalResource(String resource) {
        this.linuxResource = resource;
        this.osxResource = resource;
        this.windowsResource = resource;
    }

    public InputStream getInputStream() {
        String osName = System.getProperty("os.name").toLowerCase();
        String resource = this.linuxResource;
        if (osName.contains("mac")) {
            resource = this.osxResource;
        } else if (osName.contains("nux")) {
            resource = this.linuxResource;
        } else if (osName.contains("win")) {
            resource = this.windowsResource;
        }
        return ExternalResource.class.getResourceAsStream(resource);
    }

    public String createBinary(File workingPath) {
        try {
            File binary = this.getBinaryFile(workingPath);
            if (!binary.exists()) {
                Files.copy(this.getInputStream(), binary.toPath(), new CopyOption[0]);
                this.ensureExecutable(binary);
            }
            return binary.getPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private File getBinaryFile(File workingPath) {
        return new File(workingPath, this.getName());
    }

    private void ensureExecutable(File binary) throws IOException {
        if (binary.exists() && !System.getProperty("os.name").toLowerCase().contains("win")) {
            String binaryPath = binary.getPath();
            Runtime.getRuntime().exec("chmod +x " + binaryPath);
        }
    }

    private String getName() {
        return this.name().toLowerCase().replace("_", "");
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public String getLinuxResource() {
        return this.linuxResource;
    }

    public String getOsxResource() {
        return this.osxResource;
    }

    public String getWindowsResource() {
        return this.windowsResource;
    }
}

