/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.media.image;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;

public final class GeoTag {
    private double altitude;
    private double latitude;
    private double longitude;
    private GregorianCalendar calendar = new GregorianCalendar();
    private String latitudeRef;
    private String longitudeRef;

    public GeoTag() {
        this.calendar.setTimeInMillis(0L);
        this.latitudeRef = "";
        this.longitudeRef = "";
        this.calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public long getDateInMillis() {
        return this.calendar.getTimeInMillis();
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getLatitudeReference() {
        return this.latitudeRef;
    }

    public String getLongitudeReference() {
        return this.longitudeRef;
    }

    public String getTimestamp() {
        SimpleDateFormat timestampDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'kk:mm:ss");
        timestampDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        return timestampDateFormat.format(this.calendar.getTimeInMillis()) + "Z";
    }

    public int getTimestampAsEpochSeconds() {
        return (int)(this.calendar.getTimeInMillis() / 1000L);
    }

    public static double degreesToDecimal(double degs, double mins, double secs) {
        double decimal = Math.abs(degs) + mins / 60.0 + secs / 3600.0;
        return decimal;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    public void setDate(String date) {
        StringTokenizer st = new StringTokenizer(date, ":");
        if (st.countTokens() == 3) {
            this.calendar.set(1, Integer.parseInt(st.nextToken()));
            this.calendar.set(2, Integer.parseInt(st.nextToken()) - 1);
            this.calendar.set(5, Integer.parseInt(st.nextToken()));
        }
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
        if (this.latitudeRef.equalsIgnoreCase("N")) {
            if (this.latitude < 0.0) {
                this.latitude *= -1.0;
            }
        } else if (this.latitudeRef.equalsIgnoreCase("S") && this.latitude > 0.0) {
            this.latitude *= -1.0;
        }
    }

    public void setLatitudeReference(String latitudeRef) {
        this.latitudeRef = latitudeRef;
        if (latitudeRef.equalsIgnoreCase("N")) {
            if (this.latitude < 0.0) {
                this.latitude *= -1.0;
            }
        } else if (latitudeRef.equalsIgnoreCase("S") && this.latitude > 0.0) {
            this.latitude *= -1.0;
        }
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
        if (this.longitudeRef.equalsIgnoreCase("E")) {
            if (this.longitude < 0.0) {
                this.longitude *= -1.0;
            }
        } else if (this.longitudeRef.equalsIgnoreCase("W") && this.longitude > 0.0) {
            this.longitude *= -1.0;
        }
    }

    public void setLongitudeReference(String longitudeRef) {
        this.longitudeRef = longitudeRef;
        if (longitudeRef.equalsIgnoreCase("E")) {
            if (this.longitude < 0.0) {
                this.longitude *= -1.0;
            }
        } else if (longitudeRef.equalsIgnoreCase("W") && this.longitude > 0.0) {
            this.longitude *= -1.0;
        }
    }

    public void setTime(double hour, double min, double sec) {
        this.calendar.set(11, (int)hour);
        this.calendar.set(12, (int)min);
        this.calendar.set(13, (int)sec);
    }

    public String toString() {
        return this.latitude + ", " + this.longitude + ", " + this.altitude + " " + this.getTimestamp();
    }
}

