/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.media.image;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.teamapps.media.image.GeoTag;

public class JpegGeoTagReader {
    public static final byte[] BYTES_PER_FORMAT = new byte[]{1, 1, 1, 2, 4, 8};
    public static final int GPS_INFO_OFFSET = 34853;
    public static final int TIFF_HEADER_OFFSET = 6;
    public static final byte SEGMENTS_END = -38;
    public static final byte GPS_LATITUDE_REF = 1;
    public static final byte GPS_LATITUDE = 2;
    public static final byte GPS_LONGITUDE_REF = 3;
    public static final byte GPS_LONGITUDE = 4;
    public static final byte GPS_ALTITUDE = 6;
    public static final byte GPS_TIME = 7;
    public static final byte GPS_DATE = 29;
    private ArrayList<byte[]> segmentDataList;
    private boolean isBigEndianByteOrder;
    private byte[] byteBuffer;

    private static int calculateTagOffset(int startOffset, int entryNumber) {
        return startOffset + 2 + 12 * entryNumber;
    }

    private GeoTag extract() throws Exception {
        GeoTag geo = new GeoTag();
        String byteOrderIdentifier = this.getString(6, 2);
        if (byteOrderIdentifier.equals("MM")) {
            this.isBigEndianByteOrder = true;
        } else if (byteOrderIdentifier.equals("II")) {
            this.isBigEndianByteOrder = false;
        } else {
            return null;
        }
        int firstDirectoryOffset = this.getInt32(10) + 6;
        this.processDirectory(geo, firstDirectoryOffset);
        return geo;
    }

    private void processDirectory(GeoTag geo, int directoryOffset) throws Exception {
        int dirTagCount = this.getUnsignedInt16(directoryOffset);
        block3: for (int tagNumber = 0; tagNumber < dirTagCount; ++tagNumber) {
            int tagValueOffset;
            int tagOffset = JpegGeoTagReader.calculateTagOffset(directoryOffset, tagNumber);
            int tagType = this.getUnsignedInt16(tagOffset);
            int formatCode = this.getUnsignedInt16(tagOffset + 2);
            int componentCount = this.getInt32(tagOffset + 4);
            int byteCount = componentCount * BYTES_PER_FORMAT[formatCode];
            if (byteCount > 4) {
                int offsetVal = this.getInt32(tagOffset + 8);
                tagValueOffset = 6 + offsetVal;
            } else {
                tagValueOffset = tagOffset + 8;
            }
            switch (tagType) {
                case 34853: {
                    int subdirOffset = 6 + this.getInt32(tagValueOffset);
                    this.processDirectory(geo, subdirOffset);
                    continue block3;
                }
                default: {
                    this.processGeoInfo(geo, tagType, tagValueOffset, componentCount);
                }
            }
        }
        int finalTagOffset = JpegGeoTagReader.calculateTagOffset(directoryOffset, dirTagCount);
        int nextDirectoryOffset = this.getInt32(finalTagOffset);
        if (nextDirectoryOffset != 0) {
            nextDirectoryOffset += 6;
        }
    }

    private void processGeoInfo(GeoTag geo, int tagType, int tagValueOffset, int componentCount) throws Exception {
        switch (tagType) {
            case 6: {
                geo.setAltitude(this.getUnsignedInt32(tagValueOffset) / this.getUnsignedInt32(tagValueOffset + 4));
                break;
            }
            case 7: {
                double[] times = new double[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    times[i] = this.getUnsignedInt32(tagValueOffset + 8 * i) / this.getUnsignedInt32(tagValueOffset + 4 + 8 * i);
                }
                geo.setTime(times[0], times[1], times[2]);
                break;
            }
            case 3: {
                geo.setLongitudeReference(this.getNullTerminatedString(tagValueOffset, componentCount));
                break;
            }
            case 4: {
                double[] longitudes = new double[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    longitudes[i] = this.getUnsignedInt32(tagValueOffset + 8 * i) / this.getUnsignedInt32(tagValueOffset + 4 + 8 * i);
                }
                Double lon = GeoTag.degreesToDecimal(longitudes[0], longitudes[1], longitudes[2]);
                geo.setLongitude(lon);
                break;
            }
            case 1: {
                geo.setLatitudeReference(this.getNullTerminatedString(tagValueOffset, componentCount));
                break;
            }
            case 2: {
                double[] latitudes = new double[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    latitudes[i] = this.getUnsignedInt32(tagValueOffset + 8 * i) / this.getUnsignedInt32(tagValueOffset + 4 + 8 * i);
                }
                Double lat = GeoTag.degreesToDecimal(latitudes[0], latitudes[1], latitudes[2]);
                geo.setLatitude(lat);
                break;
            }
            case 29: {
                String date = this.getNullTerminatedString(tagValueOffset, componentCount);
                geo.setDate(date);
            }
        }
    }

    public GeoTag readMetadataSave(File file) {
        try {
            return this.readMetadata(file);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
            return null;
        }
    }

    public GeoTag readMetadata(File file) throws Exception {
        GeoTag geoLocation = new GeoTag();
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        this.segmentDataList = new ArrayList();
        this.isBigEndianByteOrder = true;
        this.readSegments(bis);
        bis.close();
        for (byte[] segment : this.segmentDataList) {
            if (segment.length <= 4 || !"EXIF".equalsIgnoreCase(new String(segment, 0, 4))) continue;
            this.byteBuffer = segment;
            geoLocation = this.extract();
        }
        return geoLocation;
    }

    private void readSegments(BufferedInputStream inputStream) throws IOException {
        try {
            boolean hasValidHeader;
            int offset = 0;
            byte[] headerBytes = new byte[2];
            if (inputStream.read(headerBytes, 0, 2) != 2) {
                hasValidHeader = false;
            } else {
                boolean bl = hasValidHeader = (headerBytes[0] & 0xFF) == 255 && (headerBytes[1] & 0xFF) == 216;
            }
            if (!hasValidHeader) {
                throw new IOException("This file is not a jpeg file.");
            }
            offset += 2;
            while (true) {
                byte segmentIdentifier = (byte)(inputStream.read() & 0xFF);
                ++offset;
                byte thisSegmentMarker = (byte)(inputStream.read() & 0xFF);
                ++offset;
                byte[] segmentLengthBytes = new byte[2];
                if (inputStream.read(segmentLengthBytes, 0, 2) != 2) {
                    throw new IOException("Malformed Jpeg data.");
                }
                offset += 2;
                int segmentLength = segmentLengthBytes[0] << 8 & 0xFF00 | segmentLengthBytes[1] & 0xFF;
                byte[] segmentBytes = new byte[segmentLength -= 2];
                if (inputStream.read(segmentBytes, 0, segmentLength) != segmentLength) {
                    throw new IOException("Jpeg data ended unexpectedly.");
                }
                offset += segmentLength;
                if (thisSegmentMarker == -38) break;
                this.segmentDataList.add(segmentBytes);
            }
            inputStream.close();
        }
        catch (IOException ioe) {
            throw new IOException("Exception processing Jpeg file: " + ioe.getMessage(), ioe);
        }
    }

    private int getUnsignedInt16(int index) throws Exception {
        if (this.isBigEndianByteOrder) {
            return this.byteBuffer[index] << 8 & 0xFF00 | this.byteBuffer[index + 1] & 0xFF;
        }
        return this.byteBuffer[index + 1] << 8 & 0xFF00 | this.byteBuffer[index] & 0xFF;
    }

    private long getUnsignedInt32(int index) throws Exception {
        if (this.isBigEndianByteOrder) {
            return (long)this.byteBuffer[index] << 24 & 0xFF000000L | (long)this.byteBuffer[index + 1] << 16 & 0xFF0000L | (long)this.byteBuffer[index + 2] << 8 & 0xFF00L | (long)this.byteBuffer[index + 3] & 0xFFL;
        }
        return (long)this.byteBuffer[index + 3] << 24 & 0xFF000000L | (long)this.byteBuffer[index + 2] << 16 & 0xFF0000L | (long)this.byteBuffer[index + 1] << 8 & 0xFF00L | (long)this.byteBuffer[index] & 0xFFL;
    }

    private int getInt32(int index) throws Exception {
        if (this.isBigEndianByteOrder) {
            return this.byteBuffer[index] << 24 & 0xFF000000 | this.byteBuffer[index + 1] << 16 & 0xFF0000 | this.byteBuffer[index + 2] << 8 & 0xFF00 | this.byteBuffer[index + 3] & 0xFF;
        }
        return this.byteBuffer[index + 3] << 24 & 0xFF000000 | this.byteBuffer[index + 2] << 16 & 0xFF0000 | this.byteBuffer[index + 1] << 8 & 0xFF00 | this.byteBuffer[index] & 0xFF;
    }

    private String getString(int index, int length) throws Exception {
        byte[] bytes = new byte[length];
        System.arraycopy(this.byteBuffer, index, bytes, 0, length);
        return new String(bytes);
    }

    private String getNullTerminatedString(int index, int maxLengthBytes) throws Exception {
        int length;
        for (length = 0; index + length < this.byteBuffer.length && this.byteBuffer[index + length] != 0 && length < maxLengthBytes; ++length) {
        }
        byte[] bytes = new byte[length];
        System.arraycopy(this.byteBuffer, index, bytes, 0, length);
        return new String(bytes);
    }
}

