/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.media.media;

import java.io.File;
import java.io.IOException;
import net.coobird.thumbnailator.Thumbnailator;
import org.apache.commons.io.FileUtils;
import org.teamapps.media.mp3.Mp3Utils;
import org.teamapps.media.pdf.PdfUtils;

public class MediaFileUtils {
    public static File createFilePreviewThumbnail(File file, String fileName) {
        if (file == null || file.length() == 0L || fileName == null) {
            return null;
        }
        if ((fileName = fileName.toLowerCase()).endsWith(".jpg") || fileName.endsWith(".png")) {
            try {
                File tempFile = File.createTempFile("temp", ".jpg");
                Thumbnailator.createThumbnail((File)file, (File)tempFile, (int)200, (int)200);
                return tempFile;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            if (fileName.endsWith(".pdf")) {
                return PdfUtils.createPdfThumbnailAsFile(file, 45);
            }
            if (fileName.endsWith(".mp3")) {
                return Mp3Utils.getMp3ThumbnailImageAsFile(file);
            }
        }
        return null;
    }

    public static String getFileSize(long length) {
        return FileUtils.byteCountToDisplaySize((long)length);
    }
}

