/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.media.meta;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.teamapps.media.exec.CommandLineExecutor;
import org.teamapps.media.exec.ExternalResource;
import org.teamapps.media.meta.MediaInfo;

public class FfProbe {
    private static final CommandLineExecutor commandLineExecutor = new CommandLineExecutor(ExternalResource.FFPROBE);
    private final ObjectMapper mapper = new ObjectMapper();
    private final MapType type = this.mapper.getTypeFactory().constructMapType(Map.class, String.class, Object.class);
    private static AtomicLong ID_GENERATOR = new AtomicLong(0L);
    private Executor executor;

    public FfProbe() {
    }

    public FfProbe(Executor executor) {
        this.executor = executor;
    }

    public Map<String, Object> readMediaInfoMap(File mediaFile) {
        StringBuilder argsBuilder = new StringBuilder();
        argsBuilder.append("-v quiet -print_format json -show_format -show_streams ").append(mediaFile.getPath()).append(" ");
        StringBuilder info = new StringBuilder();
        StringBuilder error = new StringBuilder();
        if (commandLineExecutor.executeCommand(argsBuilder.toString(), 30, info, error)) {
            String json = info.toString();
            System.out.println(json);
            try {
                if (!json.isBlank()) {
                    return (Map)this.mapper.readValue(json, (JavaType)this.type);
                }
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public MediaInfo readMediaInfo(File file) {
        Map<String, Object> map = this.readMediaInfoMap(file);
        if (map == null) {
            return null;
        }
        MediaInfo mediaInfo = new MediaInfo();
        if (map.containsKey("format")) {
            Map formatMap = (Map)map.get("format");
            mediaInfo.setFileName(this.getString("filename", formatMap));
            int duration = (int)this.parseDouble("duration", formatMap);
            mediaInfo.setDurationInSecs(duration);
            mediaInfo.setFormat(this.getString("format_name", formatMap));
            mediaInfo.setFormatDescription(this.getString("format_long_name", formatMap));
        }
        if (map.containsKey("streams")) {
            Map<String, Object> videoStream;
            List streams = (List)map.get("streams");
            Map<String, Object> audioStream = this.getFirstMediaStream(streams, true);
            if (audioStream != null) {
                mediaInfo.setContainsAudio(true);
                mediaInfo.setAudioCodec(this.getString("codec_name", audioStream));
                mediaInfo.setAudioCodecDescription(this.getString("codec_long_name", audioStream));
                mediaInfo.setAudioSamplingRate(this.parseInt("sample_rate", audioStream));
                mediaInfo.setAudioBitRate(this.parseInt("bit_rate", audioStream));
                mediaInfo.setStereoAudio(this.parseInt("channels", audioStream) == 2);
            }
            if ((videoStream = this.getFirstMediaStream(streams, false)) != null) {
                mediaInfo.setContainsVideo(true);
                mediaInfo.setVideoCodec(this.getString("codec_name", videoStream));
                mediaInfo.setVideoCodecDescription(this.getString("codec_long_name", videoStream));
                mediaInfo.setVideoBitRate(this.parseInt("bit_rate", videoStream));
                mediaInfo.setVideoWidth(this.parseInt("width", videoStream));
                mediaInfo.setVideoHeight(this.parseInt("height", videoStream));
            }
        }
        return mediaInfo;
    }

    private String getString(String key, Map<String, Object> map) {
        Object value;
        if (map.containsKey(key) && (value = map.get(key)) instanceof String) {
            return (String)value;
        }
        return null;
    }

    private int parseInt(String key, Map<String, Object> map) {
        if (map.containsKey(key)) {
            Object value = map.get(key);
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof String) {
                return Integer.parseInt((String)value);
            }
        }
        return 0;
    }

    private double parseDouble(String key, Map<String, Object> map) {
        if (map.containsKey(key)) {
            Object value = map.get(key);
            if (value instanceof Double) {
                return (Double)value;
            }
            if (value instanceof String) {
                return Double.parseDouble((String)value);
            }
        }
        return 0.0;
    }

    private Map<String, Object> getFirstMediaStream(List<Object> streams, boolean audio) {
        for (Object stream : streams) {
            Map streamMap = (Map)stream;
            if (!streamMap.containsKey("codec_type")) continue;
            if (audio && streamMap.get("codec_type").equals("audio")) {
                return streamMap;
            }
            if (audio || !streamMap.get("codec_type").equals("video")) continue;
            return streamMap;
        }
        return null;
    }
}

