/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.media.meta;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.teamapps.media.image.GeoTag;
import org.teamapps.media.image.JpegGeoTagReader;
import org.teamapps.media.meta.FfProbe;
import org.teamapps.media.meta.MediaInfo;

public class MetaDataExtractor {
    public static final Set<String> AUDIO_VIDEO_FILE_EXTENSIONS = new HashSet<String>(Arrays.asList("mp3", "aiff", "flac", "mp4", "wav", "webm", "mpg", "mp2", "mpeg", "mpe", "mpv", "ogg", "m4p", "m4v", "avi", "wmv", "mov", "qt", "flv", "swf", "mkv", "vob", "rmvb", "3gp", "3g2", "f4a"));
    private final FfProbe ffProbe = new FfProbe();
    private final JpegGeoTagReader jpegGeoTagReader = new JpegGeoTagReader();

    public MediaInfo readFile(File file) {
        GeoTag geoTag;
        if (file == null || !file.isDirectory() && file.length() == 0L) {
            return null;
        }
        String fileNameExtension = MetaDataExtractor.getFileNameExtension(file);
        if (AUDIO_VIDEO_FILE_EXTENSIONS.contains(fileNameExtension)) {
            return this.ffProbe.readMediaInfo(file);
        }
        if (fileNameExtension != null && (fileNameExtension.equals("jpg") || fileNameExtension.equals("jpeg")) && (geoTag = this.jpegGeoTagReader.readMetadataSave(file)) != null && geoTag.getLatitude() != 0.0 && geoTag.getLongitude() != 0.0) {
            MediaInfo mediaInfo = new MediaInfo();
            mediaInfo.setFileName(file.getName());
            mediaInfo.setContainsImage(true);
            mediaInfo.setImageLatitude(geoTag.getLatitude());
            mediaInfo.setImageLongitude(geoTag.getLongitude());
            mediaInfo.setImageAltitude(geoTag.getAltitude());
            mediaInfo.setTimestamp(geoTag.getTimestampAsEpochSeconds());
            return mediaInfo;
        }
        return null;
    }

    public static String getFileNameExtension(File file) {
        int pos = file.getName().lastIndexOf(46);
        if (pos <= 0) {
            return null;
        }
        return file.getName().substring(pos + 1).toLowerCase();
    }
}

