/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.media.pdf;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PdfUtils {
    public static byte[] createPdfThumbnail(File pdfFile) {
        return PdfUtils.createPdfThumbnail(pdfFile, 40);
    }

    public static File createPdfThumbnailAsFile(File pdfFile, int resolution) {
        try {
            byte[] bytes = PdfUtils.createPdfThumbnail(pdfFile, resolution);
            if (bytes != null) {
                File file = File.createTempFile("preview", ".jpg");
                Files.copy(new ByteArrayInputStream(bytes), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                return file;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static byte[] createPdfThumbnail(File pdfFile, int resolution) {
        try {
            PDDocument document = Loader.loadPDF((File)pdfFile);
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            BufferedImage image = pdfRenderer.renderImageWithDPI(0, (float)resolution, ImageType.RGB);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "JPG", bos);
            document.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<File> createPdfBoxPages(File pdfFile, int maxFiles, int resolution, int jpegQuality, int maxPngSize) throws Exception {
        long time = System.currentTimeMillis();
        ArrayList<File> pageFiles = new ArrayList<File>();
        PDDocument document = Loader.loadPDF((File)pdfFile);
        PDFRenderer pdfRenderer = new PDFRenderer(document);
        int numberOfPages = document.getNumberOfPages();
        int max = Math.min(maxFiles, numberOfPages);
        for (int page = 0; page < max; ++page) {
            BufferedImage image = pdfRenderer.renderImageWithDPI(page, (float)resolution, ImageType.RGB);
            File png = File.createTempFile("temp", ".png");
            ImageIO.write((RenderedImage)image, "PNG", png);
            if (png.length() > (long)maxPngSize) {
                File jpg = File.createTempFile("temp", ".jpg");
                ImageIO.write((RenderedImage)image, "JPG", jpg);
                if (jpg.length() > 0L && png.length() > 0L && jpg.length() < png.length()) {
                    png = jpg;
                }
            }
            pageFiles.add(png);
        }
        document.close();
        System.out.println("TIME:" + (System.currentTimeMillis() - time));
        return pageFiles;
    }

    public static int getPdfPageCount(File pdfFile) {
        try {
            PDDocument document = Loader.loadPDF((File)pdfFile);
            int pages = document.getNumberOfPages();
            document.close();
            return pages;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }
}

