/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.media.video;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.teamapps.media.ContainerFormat;
import org.teamapps.media.audio.AudioCodec;
import org.teamapps.media.exec.CommandLineExecutor;
import org.teamapps.media.exec.ConversionSpeedQualityTrade;
import org.teamapps.media.exec.ExternalResource;
import org.teamapps.media.video.VideoCodec;

public class VideoConverter {
    private static final CommandLineExecutor commandLineExecutor = new CommandLineExecutor(ExternalResource.FFMPEG);
    private Executor executor;

    public VideoConverter() {
    }

    public VideoConverter(Executor executor) {
        this.executor = executor;
    }

    public CompletableFuture<File> convertVideo(File inputFile, ContainerFormat outputFormat, AudioCodec audioCodec, int audioBitrate, VideoCodec videoCodec, int videoBitrate, ConversionSpeedQualityTrade speedQualityTrade, int timeoutSeconds) {
        try {
            File outputFile = File.createTempFile("converted-video-", "." + outputFormat.getFileSuffix());
            String args = "-i " + inputFile.getPath() + " -c:a " + audioCodec.getFfmpegName() + " -b:a " + audioBitrate + " -c:v " + videoCodec.getFfmpegName() + " -b:v " + videoBitrate + " -preset " + speedQualityTrade.getFfmpegOption() + " -y -hide_banner " + String.valueOf(outputFile);
            return commandLineExecutor.executeCommandAsync(args, timeoutSeconds, this.executor).thenApply(aVoid -> outputFile);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<File> createVideoThumbnail(File inputFile, int minutes, int seconds, int timeoutSeconds) {
        try {
            File temp = Files.createTempDirectory("temp", new FileAttribute[0]).toFile();
            File newInput = new File(temp, "video-copy" + System.currentTimeMillis() + ".mp4");
            Files.copy(inputFile.toPath(), newInput.toPath(), new CopyOption[0]);
            File outputFile = new File(temp, "video" + System.currentTimeMillis() + ".jpg");
            String args = "-ss 00:" + this.formatTimeValue(minutes) + ":" + this.formatTimeValue(seconds) + " -i " + newInput.getPath() + " -vframes 1 " + outputFile.getPath() + " -hide_banner ";
            return commandLineExecutor.executeCommandAsync(args, timeoutSeconds, this.executor).thenApply(aVoid -> outputFile);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private String formatTimeValue(int value) {
        return value < 9 ? "0" + value : "" + value;
    }
}

