/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.media.video;

import java.io.File;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.teamapps.media.exec.CommandLineExecutor;
import org.teamapps.media.exec.ExternalResource;

public class VideoDownloader {
    private static final CommandLineExecutor commandLineExecutor = new CommandLineExecutor(ExternalResource.YOUTUBE_DOWNLOADER);
    private static AtomicLong ID_GENERATOR = new AtomicLong(0L);
    private Executor executor;

    public VideoDownloader() {
    }

    public VideoDownloader(Executor executor) {
        this.executor = executor;
    }

    public CompletableFuture<File> downloadVideo(String url, int timeoutSeconds) {
        return this.downloadVideo(url, null, 0, timeoutSeconds);
    }

    public CompletableFuture<File> downloadVideo(String url, String proxyHost, int proxyPort, int timeoutSeconds) {
        try {
            String id = this.getNexId();
            File path = File.createTempFile("temp", "temp").getParentFile();
            String args = this.createProxyArgs(proxyHost, proxyPort) + "--output " + path.getPath() + "/video-" + id + ".%(ext)s --restrict-filenames " + url;
            return commandLineExecutor.executeCommandAsync(args, timeoutSeconds, this.executor).thenApply(aVoid -> this.findFile(path, id));
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private String createProxyArgs(String proxyHost, int proxyPort) {
        return proxyHost != null ? "--proxy " + proxyHost + ":" + proxyPort + " " : "";
    }

    private String getNexId() {
        return "IDx" + System.currentTimeMillis() + "-" + ID_GENERATOR.incrementAndGet() + "xv";
    }

    private File findFile(File path, String partOfName) {
        return Arrays.stream(path.listFiles()).filter(file -> file.getName().contains(partOfName)).findAny().orElse(null);
    }
}

