/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.message.protocol.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teamapps.message.protocol.message.AttributeType;
import org.teamapps.message.protocol.message.DefinitionCache;
import org.teamapps.message.protocol.message.EnumDefinitionImpl;
import org.teamapps.message.protocol.message.Message;
import org.teamapps.message.protocol.message.MessageDefinition;
import org.teamapps.message.protocol.model.AttributeDefinition;
import org.teamapps.message.protocol.model.EnumDefinition;
import org.teamapps.message.protocol.model.MessageModel;
import org.teamapps.message.protocol.utils.MessageUtils;

public class AbstractAttributeDefinition
implements AttributeDefinition {
    private final MessageModel parent;
    private final String name;
    private final int key;
    private final AttributeType type;
    private final String defaultValue;
    private final String comment;
    private final Message specificType;
    private final MessageModel referencedObject;
    private final boolean multiReference;
    private final EnumDefinition enumDefinition;

    public AbstractAttributeDefinition(MessageModel parent, String name, int key, AttributeType type, Message specificType) {
        this(parent, name, key, type, specificType, null, null);
    }

    public AbstractAttributeDefinition(MessageModel parent, String name, int key, AttributeType type, Message specificType, String defaultValue, String comment) {
        this.parent = parent;
        this.name = name;
        this.key = key;
        this.type = type;
        this.specificType = specificType;
        this.defaultValue = defaultValue;
        this.comment = comment;
        this.referencedObject = null;
        this.multiReference = false;
        this.enumDefinition = null;
    }

    public AbstractAttributeDefinition(MessageModel parent, String name, int key, EnumDefinition enumDefinition, Message specificType) {
        this(parent, name, key, enumDefinition, specificType, null, null);
    }

    public AbstractAttributeDefinition(MessageModel parent, String name, int key, EnumDefinition enumDefinition, Message specificType, String defaultValue, String comment) {
        this.parent = parent;
        this.name = name;
        this.key = key;
        this.type = AttributeType.ENUM;
        this.specificType = specificType;
        this.defaultValue = defaultValue;
        this.comment = comment;
        this.referencedObject = null;
        this.multiReference = false;
        this.enumDefinition = enumDefinition;
    }

    public AbstractAttributeDefinition(MessageModel parent, String name, int key, Message specificType, MessageModel referencedObject, boolean multiReference) {
        this(parent, name, key, specificType, referencedObject, multiReference, null);
    }

    public AbstractAttributeDefinition(MessageModel parent, String name, int key, Message specificType, MessageModel referencedObject, boolean multiReference, String comment) {
        this.parent = parent;
        this.name = name;
        this.key = key;
        this.type = multiReference ? AttributeType.OBJECT_MULTI_REFERENCE : AttributeType.OBJECT_SINGLE_REFERENCE;
        this.specificType = specificType;
        this.defaultValue = null;
        this.comment = comment;
        this.referencedObject = referencedObject;
        this.multiReference = multiReference;
        this.enumDefinition = null;
    }

    public AbstractAttributeDefinition(MessageModel parent, byte[] bytes, DefinitionCache definitionCache) throws IOException {
        this(parent, new DataInputStream(new ByteArrayInputStream(bytes)), definitionCache);
    }

    public AbstractAttributeDefinition(MessageModel parent, DataInputStream dis, DefinitionCache definitionCache) throws IOException {
        this.parent = parent;
        this.name = MessageUtils.readString(dis);
        this.key = dis.readInt();
        this.type = AttributeType.getById(dis.readInt());
        this.specificType = MessageUtils.readMessageOrNull(dis);
        this.defaultValue = MessageUtils.readString(dis);
        this.comment = MessageUtils.readString(dis);
        if (this.type == AttributeType.OBJECT_SINGLE_REFERENCE || this.type == AttributeType.OBJECT_MULTI_REFERENCE) {
            this.multiReference = dis.readBoolean();
            if (dis.readBoolean()) {
                String objectUuid = MessageUtils.readString(dis);
                this.referencedObject = definitionCache.getModel(objectUuid);
            } else {
                this.referencedObject = new MessageDefinition(dis, definitionCache);
            }
            this.enumDefinition = null;
        } else if (this.type == AttributeType.ENUM) {
            if (dis.readBoolean()) {
                String enumName = MessageUtils.readString(dis);
                this.enumDefinition = definitionCache.getEnum(enumName);
            } else {
                String enumName = MessageUtils.readString(dis);
                int values = dis.readInt();
                ArrayList<String> enumValues = new ArrayList<String>();
                for (int i = 0; i < values; ++i) {
                    enumValues.add(MessageUtils.readString(dis));
                }
                this.enumDefinition = new EnumDefinitionImpl(enumName, enumValues);
                definitionCache.addEnum(this.enumDefinition);
            }
            this.referencedObject = null;
            this.multiReference = false;
        } else {
            this.enumDefinition = null;
            this.referencedObject = null;
            this.multiReference = false;
        }
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        this.write(dos, new DefinitionCache());
    }

    @Override
    public void write(DataOutputStream dos, DefinitionCache definitionCache) throws IOException {
        MessageUtils.writeString(dos, this.name);
        dos.writeInt(this.key);
        dos.writeInt(this.type.getId());
        MessageUtils.writeNullableMessage(dos, this.specificType);
        MessageUtils.writeString(dos, this.defaultValue);
        MessageUtils.writeString(dos, this.comment);
        if (this.isReferenceProperty()) {
            dos.writeBoolean(this.multiReference);
            if (definitionCache.containsModel(this.referencedObject)) {
                dos.writeBoolean(true);
                MessageUtils.writeString(dos, this.referencedObject.getObjectUuid());
            } else {
                definitionCache.addModel(this.referencedObject);
                dos.writeBoolean(false);
                this.referencedObject.write(dos, definitionCache);
            }
        } else if (this.type == AttributeType.ENUM) {
            if (definitionCache.containsEnum(this.enumDefinition)) {
                dos.writeBoolean(true);
                MessageUtils.writeString(dos, this.enumDefinition.getName());
            } else {
                dos.writeBoolean(false);
                MessageUtils.writeString(dos, this.enumDefinition.getName());
                List<String> enumValues = this.enumDefinition.getEnumValues();
                dos.writeInt(enumValues.size());
                for (int i = 0; i < enumValues.size(); ++i) {
                    MessageUtils.writeString(dos, enumValues.get(i));
                }
                definitionCache.addEnum(this.enumDefinition);
            }
        }
    }

    @Override
    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.write(dos);
        dos.close();
        return bos.toByteArray();
    }

    @Override
    public MessageModel getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getKey() {
        return this.key;
    }

    @Override
    public AttributeType getType() {
        return this.type;
    }

    @Override
    public Message getSpecificType() {
        return this.specificType;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isReferenceProperty() {
        return this.type == AttributeType.OBJECT_SINGLE_REFERENCE || this.type == AttributeType.OBJECT_MULTI_REFERENCE;
    }

    @Override
    public boolean isEnumProperty() {
        return this.type == AttributeType.ENUM;
    }

    @Override
    public boolean isMetaDataField() {
        return MessageDefinition.META_FIELD_NAMES.contains(this.name);
    }

    @Override
    public EnumDefinition getEnumDefinition() {
        return this.enumDefinition;
    }

    @Override
    public MessageModel getReferencedObject() {
        return this.referencedObject;
    }

    @Override
    public boolean isMultiReference() {
        return this.multiReference;
    }

    @Override
    public String explain(int level, Set<String> printedObjects) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t".repeat(level)).append(this.getName()).append(", ");
        sb.append((Object)this.getType());
        if (this.isReferenceProperty()) {
            MessageModel model = this.getReferencedObject();
            sb.append(" ").append(this.isMultiReference() ? "multi" : "single").append(" -> ");
            sb.append("\n");
            if (printedObjects.contains(model.getObjectUuid())) {
                sb.append("\t".repeat(level + 1)).append(model.getName()).append(" [").append(model.getObjectUuid()).append("], ").append(" ...");
            } else {
                sb.append(model.explain(level + 1, printedObjects));
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.explain(0, new HashSet<String>());
    }
}

