/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.message.protocol.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.teamapps.message.protocol.message.EnumDefinitionImpl;
import org.teamapps.message.protocol.message.Message;
import org.teamapps.message.protocol.message.MessageDefinition;
import org.teamapps.message.protocol.message.MessageModelRegistry;
import org.teamapps.message.protocol.model.EnumDefinition;
import org.teamapps.message.protocol.model.MessageModel;
import org.teamapps.message.protocol.model.ModelCollection;
import org.teamapps.message.protocol.model.ModelRegistry;
import org.teamapps.message.protocol.model.PojoObjectDecoder;
import org.teamapps.message.protocol.service.ServiceProtocol;

public class MessageModelCollection
implements ModelCollection {
    private final String name;
    private final String namespace;
    private final int version;
    private final List<MessageModel> models = new ArrayList<MessageModel>();
    private final List<EnumDefinition> enums = new ArrayList<EnumDefinition>();
    private final Map<String, MessageModel> modelByKey = new ConcurrentHashMap<String, MessageModel>();
    private Map<String, PojoObjectDecoder<? extends Message>> decoderByUuid = new ConcurrentHashMap<String, PojoObjectDecoder<? extends Message>>();
    private List<ServiceProtocol> serviceProtocols = new ArrayList<ServiceProtocol>();

    public MessageModelCollection(String name, String namespace, int version) {
        this.name = name;
        this.namespace = namespace;
        this.version = version;
    }

    public MessageDefinition createModel(String name, String uuid) {
        return this.createModel(name, uuid, true);
    }

    public MessageDefinition createModel(String name, String uuid, boolean messageRecord) {
        MessageDefinition definition = new MessageDefinition(uuid, name, messageRecord, this.version);
        this.addModel(definition);
        return definition;
    }

    public MessageDefinition createModel(String name, String uuid, Message specificType, boolean messageRecord) {
        MessageDefinition definition = new MessageDefinition(uuid, name, specificType, messageRecord, this.version);
        this.addModel(definition);
        return definition;
    }

    public MessageDefinition createModel(String name, String uuid, int modelVersion, Message specificType, boolean messageRecord) {
        MessageDefinition definition = new MessageDefinition(uuid, name, specificType, messageRecord, modelVersion);
        this.addModel(definition);
        return definition;
    }

    public void addModel(MessageModel model) {
        this.models.add(model);
        this.modelByKey.put(model.getObjectUuid(), model);
    }

    public EnumDefinition createEnum(String name, String ... enumValues) {
        return this.createEnum(name, Arrays.asList(enumValues));
    }

    public EnumDefinition createEnum(String name, List<String> enumValues) {
        EnumDefinitionImpl definition = new EnumDefinitionImpl(name, enumValues);
        this.enums.add(definition);
        return definition;
    }

    public ServiceProtocol createService(String serviceName) {
        ServiceProtocol serviceSchema = new ServiceProtocol(serviceName);
        this.serviceProtocols.add(serviceSchema);
        return serviceSchema;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public short getVersion() {
        return (short)this.version;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public MessageModel getModel(String uuid) {
        return this.modelByKey.get(uuid);
    }

    @Override
    public List<MessageModel> getModels() {
        return this.models;
    }

    @Override
    public List<EnumDefinition> getEnums() {
        return this.enums;
    }

    @Override
    public ModelRegistry createRegistry() {
        return new MessageModelRegistry(this);
    }

    @Override
    public List<ServiceProtocol> getProtocolServiceSchemas() {
        return this.serviceProtocols;
    }

    @Override
    public void addMessageDecoder(String uuid, PojoObjectDecoder<? extends Message> decoder) {
        this.decoderByUuid.put(uuid, decoder);
    }

    @Override
    public PojoObjectDecoder<? extends Message> getMessageDecoder(String uuid) {
        return this.decoderByUuid.get(uuid);
    }

    @Override
    public boolean containsDecoder(String uuid) {
        return this.decoderByUuid.containsKey(uuid);
    }

    @Override
    public byte[] toBytes() {
        return new byte[0];
    }
}

