/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.message.protocol.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.teamapps.message.protocol.file.FileData;
import org.teamapps.message.protocol.file.FileDataReader;
import org.teamapps.message.protocol.file.FileDataType;
import org.teamapps.message.protocol.file.FileDataWriter;
import org.teamapps.message.protocol.message.AttributeType;
import org.teamapps.message.protocol.message.MessageAttribute;
import org.teamapps.message.protocol.message.MessageAttributeImpl;
import org.teamapps.message.protocol.message.MessageDefinition;
import org.teamapps.message.protocol.message.MessageRecord;
import org.teamapps.message.protocol.model.AttributeDefinition;
import org.teamapps.message.protocol.model.MessageModel;
import org.teamapps.message.protocol.model.ModelCollection;
import org.teamapps.message.protocol.model.ModelRegistry;
import org.teamapps.message.protocol.model.PojoObjectDecoderRegistry;
import org.teamapps.message.protocol.utils.MessageUtils;
import org.teamapps.message.protocol.xml.XmlBuilder;
import org.teamapps.message.protocol.xml.XmlNode;
import org.teamapps.message.protocol.xml.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class Message
implements MessageRecord {
    private final MessageModel messageModel;
    private final List<MessageAttribute> attributes = new ArrayList<MessageAttribute>();
    private final Map<String, MessageAttribute> attributesByName = new HashMap<String, MessageAttribute>();

    public Message(MessageModel messageModel) {
        this.messageModel = messageModel;
    }

    public Message(MessageRecord message, ModelCollection modelCollection) {
        this.messageModel = modelCollection.getModel(message.getMessageDefUuid());
        for (MessageAttribute attribute : message.getAttributes()) {
            AttributeDefinition remappedDefinition = this.messageModel.getAttributeDefinitionByKey(attribute.getAttributeDefinition().getKey());
            MessageAttribute messageAttribute = remappedDefinition == null ? attribute : new MessageAttributeImpl((MessageAttributeImpl)attribute, remappedDefinition, modelCollection);
            this.attributes.add(messageAttribute);
            this.attributesByName.put(messageAttribute.getAttributeDefinition().getName(), messageAttribute);
        }
    }

    public Message(byte[] bytes, MessageModel model, FileDataReader fileProvider, PojoObjectDecoderRegistry decoderRegistry) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(bytes)), model, fileProvider, decoderRegistry);
    }

    public Message(byte[] bytes, ModelRegistry modelRegistry, FileDataReader fileProvider, PojoObjectDecoderRegistry decoderRegistry) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(bytes)), modelRegistry, fileProvider, decoderRegistry);
    }

    public Message(DataInputStream dis, ModelRegistry modelRegistry, FileDataReader fileDataReader, PojoObjectDecoderRegistry decoderRegistry) throws IOException {
        String objectUuid = MessageUtils.readString(dis);
        short modelVersion = dis.readShort();
        this.messageModel = modelRegistry.getModel(objectUuid, modelVersion);
        int attributesCount = dis.readShort();
        for (int i = 0; i < attributesCount; ++i) {
            MessageAttributeImpl messageAttribute = new MessageAttributeImpl(dis, this.messageModel, fileDataReader, decoderRegistry);
            this.attributes.add(messageAttribute);
            this.attributesByName.put(messageAttribute.getAttributeDefinition().getName(), messageAttribute);
        }
    }

    public Message(DataInputStream dis, MessageModel model, FileDataReader fileDataReader, PojoObjectDecoderRegistry decoderRegistry) throws IOException {
        this.messageModel = model;
        String objectUuid = MessageUtils.readString(dis);
        if (!model.getObjectUuid().equals(objectUuid)) {
            throw new RuntimeException("Cannot parse message with wrong model:" + objectUuid + ", expected:" + this.messageModel.getObjectUuid());
        }
        short modelVersion = dis.readShort();
        if (model.getModelVersion() != modelVersion) {
            System.out.println("Wrong model version " + String.valueOf(model) + ", expected: " + model.getModelVersion());
        }
        int attributesCount = dis.readShort();
        for (int i = 0; i < attributesCount; ++i) {
            MessageAttributeImpl messageAttribute = new MessageAttributeImpl(dis, this.messageModel, fileDataReader, decoderRegistry);
            this.attributes.add(messageAttribute);
            this.attributesByName.put(messageAttribute.getAttributeDefinition().getName(), messageAttribute);
        }
    }

    public Message(byte[] bytes) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(bytes)), null);
    }

    public Message(byte[] bytes, FileDataReader fileDataReader) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(bytes)), fileDataReader);
    }

    public Message(DataInputStream dis, FileDataReader fileDataReader) throws IOException {
        String objectUuid = MessageUtils.readString(dis);
        short modelVersion = dis.readShort();
        this.messageModel = new MessageDefinition(objectUuid, null, false, modelVersion);
        int attributesCount = dis.readShort();
        for (int i = 0; i < attributesCount; ++i) {
            MessageAttributeImpl messageAttribute = new MessageAttributeImpl(dis, this.messageModel, fileDataReader, null);
            this.attributes.add(messageAttribute);
            this.attributesByName.put(messageAttribute.getAttributeDefinition().getName(), messageAttribute);
        }
    }

    public Message(String xml, MessageModel model, FileDataReader fileDataReader, PojoObjectDecoderRegistry decoderRegistry) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element xmlNode = document.getDocumentElement();
        this.messageModel = model;
        for (AttributeDefinition definition : this.messageModel.getAttributeDefinitions()) {
            Element childElement = XmlUtils.readChildElement(xmlNode, definition.getName());
            if (childElement == null) continue;
            MessageAttributeImpl messageAttribute = new MessageAttributeImpl(childElement, definition, fileDataReader, decoderRegistry);
            this.attributes.add(messageAttribute);
            this.attributesByName.put(messageAttribute.getAttributeDefinition().getName(), messageAttribute);
        }
    }

    public Message(Element xmlNode, MessageModel model, FileDataReader fileDataReader, PojoObjectDecoderRegistry decoderRegistry) {
        this.messageModel = model;
        for (AttributeDefinition definition : this.messageModel.getAttributeDefinitions()) {
            Element childElement = XmlUtils.readChildElement(xmlNode, definition.getName());
            if (childElement == null) continue;
            MessageAttributeImpl messageAttribute = new MessageAttributeImpl(childElement, definition, fileDataReader, decoderRegistry);
            this.attributes.add(messageAttribute);
            this.attributesByName.put(messageAttribute.getAttributeDefinition().getName(), messageAttribute);
        }
    }

    public static String readMessageUuid(byte[] bytes) throws IOException {
        return MessageUtils.readString(bytes, 0);
    }

    public static Message readXml(String xml, MessageModel model, FileDataReader fileDataReader, PojoObjectDecoderRegistry decoderRegistry) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        return new Message(document.getDocumentElement(), model, fileDataReader, decoderRegistry);
    }

    protected Message setDefaultValues() {
        return this.setDefaultValues(null);
    }

    protected Message setDefaultValues(ModelCollection modelCollection) {
        for (AttributeDefinition attributeDefinition : this.messageModel.getAttributeDefinitions()) {
            String name = attributeDefinition.getName();
            if (attributeDefinition.isReferenceProperty()) {
                String refUuid = attributeDefinition.getReferencedObject().getObjectUuid();
                if (modelCollection == null || !modelCollection.containsDecoder(refUuid)) continue;
                Message defaultMessage = modelCollection.getMessageDecoder(attributeDefinition.getReferencedObject().getObjectUuid()).defaultMessage();
                if (attributeDefinition.isMultiReference()) {
                    this.setReferencedObjects(name, new ArrayList<Message>(Collections.singletonList(defaultMessage)));
                    continue;
                }
                this.setReferencedObject(name, defaultMessage);
                continue;
            }
            String s = attributeDefinition.getDefaultValue();
            if (s == null) continue;
            switch (attributeDefinition.getType()) {
                case BOOLEAN: {
                    this.setBooleanAttribute(name, s.equals("1") || s.equals("true"));
                    break;
                }
                case BYTE: {
                    this.setByteAttribute(name, (byte)Integer.parseInt(s));
                    break;
                }
                case INT: 
                case ENUM: {
                    this.setIntAttribute(name, Integer.parseInt(s));
                    break;
                }
                case LONG: {
                    this.setLongAttribute(name, Long.parseLong(s));
                    break;
                }
                case FLOAT: {
                    this.setFloatAttribute(name, Float.parseFloat(s));
                    break;
                }
                case DOUBLE: {
                    this.setDoubleAttribute(name, Double.parseDouble(s));
                    break;
                }
                case STRING: {
                    this.setStringAttribute(name, s);
                    break;
                }
                case BITSET: {
                    break;
                }
                case BYTE_ARRAY: {
                    this.setByteArrayAttribute(name, Base64.getDecoder().decode(s));
                    break;
                }
                case INT_ARRAY: {
                    break;
                }
                case LONG_ARRAY: {
                    break;
                }
                case FLOAT_ARRAY: {
                    break;
                }
                case DOUBLE_ARRAY: {
                    break;
                }
                case STRING_ARRAY: {
                    break;
                }
                case FILE: {
                    break;
                }
                case TIMESTAMP_32: {
                    this.setTimestampAttribute(name, Instant.ofEpochSecond(Integer.parseInt(s)));
                    break;
                }
                case TIMESTAMP_64: {
                    this.setTimestampAttribute(name, Instant.ofEpochMilli(Long.parseLong(s)));
                    break;
                }
                case DATE_TIME: {
                    this.setDateTimeAttribute(name, LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(s)), ZoneOffset.UTC));
                    break;
                }
                case DATE: {
                    this.setDateAttribute(name, LocalDate.ofEpochDay(Long.parseLong(s)));
                    break;
                }
                case TIME: {
                    this.setTimeAttribute(name, LocalTime.ofSecondOfDay(Integer.parseInt(s)));
                    break;
                }
            }
        }
        return this;
    }

    @Override
    public MessageModel getModel() {
        return this.messageModel;
    }

    @Override
    public String getMessageDefUuid() {
        return this.messageModel.getObjectUuid();
    }

    @Override
    public String getMessageDefName() {
        return this.messageModel.getName();
    }

    @Override
    public List<MessageAttribute> getAttributes() {
        return this.attributes;
    }

    public int getAttributeKey(String attributeName) {
        return this.messageModel.getAttributeDefinitionByName(attributeName).getKey();
    }

    public void write(DataOutputStream dos) throws IOException {
        this.write(dos, null);
    }

    public void write(DataOutputStream dos, FileDataWriter fileDataWriter) throws IOException {
        this.write(dos, fileDataWriter, false);
    }

    public void write(DataOutputStream dos, FileDataWriter fileDataWriter, boolean updateFileData) throws IOException {
        MessageUtils.writeString(dos, this.messageModel.getObjectUuid());
        dos.writeShort(this.messageModel.getModelVersion());
        dos.writeShort(this.attributes.size());
        for (MessageAttribute field : this.attributes) {
            field.write(dos, fileDataWriter, updateFileData);
        }
    }

    @Override
    public byte[] toBytes() throws IOException {
        return this.toBytes(null);
    }

    @Override
    public byte[] toBytes(FileDataWriter fileDataWriter) throws IOException {
        return this.toBytes(fileDataWriter, false);
    }

    @Override
    public byte[] toBytes(FileDataWriter fileDataWriter, boolean updateFileData) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.write(dos, fileDataWriter, updateFileData);
        dos.close();
        return bos.toByteArray();
    }

    @Override
    public String toXml() throws IOException {
        return this.toXml(false, null);
    }

    public String toXml(boolean withComments, FileDataWriter fileDataWriter) throws IOException {
        XmlNode xmlNode = this.toXml(null, withComments, fileDataWriter);
        XmlBuilder xmlBuilder = new XmlBuilder(xmlNode);
        return xmlBuilder.getXml();
    }

    protected XmlNode toXml(XmlNode parentNode, boolean withComments, FileDataWriter fileDataWriter) throws IOException {
        XmlNode xmlNode;
        XmlNode xmlNode2 = xmlNode = withComments ? new XmlNode(this.getMessageDefName(), null, this.messageModel.getComment()) : new XmlNode(this.getMessageDefName());
        if (!withComments) {
            for (MessageAttribute attribute : this.getAttributes()) {
                MessageAttributeImpl messageAttribute = (MessageAttributeImpl)attribute;
                messageAttribute.toXml(xmlNode, false, fileDataWriter);
            }
        } else {
            for (AttributeDefinition attributeDefinition : this.messageModel.getAttributeDefinitions()) {
                MessageAttribute attribute = this.getAttribute(attributeDefinition.getName());
                if (attribute != null) {
                    MessageAttributeImpl messageAttribute = (MessageAttributeImpl)attribute;
                    messageAttribute.toXml(xmlNode, true, fileDataWriter);
                    continue;
                }
                if (attributeDefinition.getComment() == null && attributeDefinition.getDefaultValue() == null) continue;
                xmlNode.addChild(new XmlNode(attributeDefinition.getName(), attributeDefinition.getDefaultValue(), attributeDefinition.getComment()));
            }
        }
        if (parentNode != null) {
            parentNode.addChild(xmlNode);
            return parentNode;
        }
        return xmlNode;
    }

    public void deleteAllEmbeddedFiles() {
        for (MessageAttribute attribute : this.attributes) {
            List<Message> referencedObjects;
            AttributeType type = attribute.getAttributeDefinition().getType();
            String propertyName = attribute.getAttributeDefinition().getName();
            if (type == AttributeType.FILE) {
                File file;
                FileData fileData = this.getFileData(propertyName);
                if (fileData == null || fileData.getType() != FileDataType.LOCAL_FILE || !(file = new File(fileData.getDescriptor())).exists()) continue;
                file.delete();
                continue;
            }
            if (type == AttributeType.OBJECT_SINGLE_REFERENCE) {
                Message referencedObject = this.getReferencedObject(propertyName);
                if (referencedObject == null) continue;
                referencedObject.deleteAllEmbeddedFiles();
                continue;
            }
            if (type != AttributeType.OBJECT_MULTI_REFERENCE || (referencedObjects = this.getReferencedObjects(propertyName)) == null) continue;
            referencedObjects.forEach(Message::deleteAllEmbeddedFiles);
        }
    }

    public Message setReferencedObject(String name, Message value) {
        this.setAttribute(name, value);
        return this;
    }

    public Message setReferencedObjects(String name, List<Message> value) {
        this.setAttribute(name, value);
        return this;
    }

    public <TYPE extends Message> Message setReferencedObjectAsType(String name, TYPE value) {
        this.setAttribute(name, value);
        return this;
    }

    public <TYPE extends Message> Message setReferencedObjectsAsType(String name, List<TYPE> value) {
        this.setAttribute(name, value);
        return this;
    }

    public Message setBooleanAttribute(String name, boolean value) {
        this.setAttribute(name, value);
        return this;
    }

    public Message setByteAttribute(String name, byte value) {
        this.setAttribute(name, value);
        return this;
    }

    public Message setIntAttribute(String name, int value) {
        this.setAttribute(name, value);
        return this;
    }

    public Message setLongAttribute(String name, long value) {
        this.setAttribute(name, value);
        return this;
    }

    public Message setFloatAttribute(String name, float value) {
        this.setAttribute(name, Float.valueOf(value));
        return this;
    }

    public Message setDoubleAttribute(String name, double value) {
        this.setAttribute(name, value);
        return this;
    }

    public Message setStringAttribute(String name, String value) {
        this.setAttribute(name, value);
        return this;
    }

    public Message setFileData(String name, FileData value) {
        this.setAttribute(name, value);
        return this;
    }

    public Message setFileData(String name, File file) {
        this.setAttribute(name, file != null ? FileData.create(file) : null);
        return this;
    }

    public Message setFileData(String name, File file, String fileName) {
        this.setAttribute(name, file != null ? FileData.create(file, fileName) : null);
        return this;
    }

    public Message setBitSetAttribute(String name, BitSet value) {
        this.setAttribute(name, value);
        return this;
    }

    public Message setByteArrayAttribute(String name, byte[] value) {
        this.setAttribute(name, value);
        return this;
    }

    public Message setIntArrayAttribute(String name, int[] value) {
        this.setAttribute(name, value);
        return this;
    }

    public Message setLongArrayAttribute(String name, long[] value) {
        this.setAttribute(name, value);
        return this;
    }

    public Message setFloatArrayAttribute(String name, float[] value) {
        this.setAttribute(name, value);
        return this;
    }

    public Message setDoubleArrayAttribute(String name, double[] value) {
        this.setAttribute(name, value);
        return this;
    }

    public Message setStringArrayAttribute(String name, String[] value) {
        this.setAttribute(name, value);
        return this;
    }

    public Message setStringArrayAsList(String name, List<String> value) {
        String[] v = value != null && !value.isEmpty() ? value.toArray(new String[0]) : null;
        this.setAttribute(name, v);
        return this;
    }

    public Message setTimestampAttribute(String name, Instant value) {
        this.setAttribute(name, value);
        return this;
    }

    public Message setDateTimeAttribute(String name, LocalDateTime value) {
        this.setAttribute(name, value);
        return this;
    }

    public Message setDateAttribute(String name, LocalDate value) {
        this.setAttribute(name, value);
        return this;
    }

    public Message setTimeAttribute(String name, LocalTime value) {
        this.setAttribute(name, value);
        return this;
    }

    public Message setGenericMessageAttribute(String name, Message value) {
        this.setAttribute(name, value);
        return this;
    }

    public Message getReferencedObject(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getReferencedObject();
        }
        return null;
    }

    public List<Message> getReferencedObjects(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getReferencedObjects();
        }
        return null;
    }

    public <TYPE extends Message> TYPE getReferencedObjectAsType(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getReferencedObjectAsType();
        }
        return null;
    }

    public <TYPE extends Message> List<TYPE> getReferencedObjectsAsType(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getReferencedObjectsAsType();
        }
        return null;
    }

    public boolean isEmpty(String propertyName) {
        return this.getAttribute(propertyName) == null;
    }

    public boolean getBooleanAttribute(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getBooleanAttribute();
        }
        return false;
    }

    public byte getByteAttribute(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getByteAttribute();
        }
        return 0;
    }

    public int getIntAttribute(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getIntAttribute();
        }
        return 0;
    }

    public long getLongAttribute(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getLongAttribute();
        }
        return 0L;
    }

    public float getFloatAttribute(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getFloatAttribute();
        }
        return 0.0f;
    }

    public double getDoubleAttribute(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getDoubleAttribute();
        }
        return 0.0;
    }

    public String getStringAttribute(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getStringAttribute();
        }
        return null;
    }

    public FileData getFileData(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getFileData();
        }
        return null;
    }

    public File getFile(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getFileData().getAsFile();
        }
        return null;
    }

    public String getFileDataFileName(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getFileDataFileName();
        }
        return null;
    }

    public long getFileDataFileLength(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getFileDataFileLength();
        }
        return 0L;
    }

    public BitSet getBitSetAttribute(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getBitSetAttribute();
        }
        return null;
    }

    public byte[] getByteArrayAttribute(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getByteArrayAttribute();
        }
        return null;
    }

    public int[] getIntArrayAttribute(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getIntArrayAttribute();
        }
        return null;
    }

    public long[] getLongArrayAttribute(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getLongArrayAttribute();
        }
        return null;
    }

    public float[] getFloatArrayAttribute(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getFloatArrayAttribute();
        }
        return null;
    }

    public double[] getDoubleArrayAttribute(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getDoubleArrayAttribute();
        }
        return null;
    }

    public String[] getStringArrayAttribute(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getStringArrayAttribute();
        }
        return null;
    }

    public List<String> getStringArrayAsList(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return Arrays.asList(property.getStringArrayAttribute());
        }
        return Collections.emptyList();
    }

    public Instant getTimestampAttribute(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getTimestampAttribute();
        }
        return null;
    }

    public LocalDateTime getDateTimeAttribute(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getDateTimeAttribute();
        }
        return null;
    }

    public LocalDate getDateAttribute(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getDateAttribute();
        }
        return null;
    }

    public LocalTime getTimeAttribute(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getTimeAttribute();
        }
        return null;
    }

    public Message getGenericMessageAttribute(String propertyName) {
        MessageAttribute property = this.getAttribute(propertyName);
        if (property != null) {
            return property.getGenericMessageAttribute();
        }
        return null;
    }

    @Override
    public int getRecordId() {
        MessageAttribute property = this.getAttribute("recordId");
        if (property != null) {
            return property.getIntAttribute();
        }
        return 0;
    }

    @Override
    public Message setRecordId(int id) {
        this.setAttribute("recordId", id);
        return this;
    }

    public Instant getRecordCreationDate() {
        MessageAttribute property = this.getAttribute("recordCreationDate");
        if (property != null) {
            return property.getTimestampAttribute();
        }
        return null;
    }

    public Message setRecordCreationDate(Instant value) {
        this.setAttribute("recordCreationDate", value);
        return this;
    }

    public Instant getRecordModificationDate() {
        MessageAttribute property = this.getAttribute("recordModificationDate");
        if (property != null) {
            return property.getTimestampAttribute();
        }
        return null;
    }

    @Override
    public Message setRecordModificationDate(Instant value) {
        this.setAttribute("recordModificationDate", value);
        return this;
    }

    public int getRecordCreatedBy() {
        MessageAttribute property = this.getAttribute("recordCreatedBy");
        if (property != null) {
            return property.getIntAttribute();
        }
        return 0;
    }

    public Message setRecordCreatedBy(int userId) {
        this.setAttribute("recordCreatedBy", userId);
        return this;
    }

    public int getRecordModifiedBy() {
        MessageAttribute property = this.getAttribute("recordModifiedBy");
        if (property != null) {
            return property.getIntAttribute();
        }
        return 0;
    }

    public Message setRecordModifiedBy(int userId) {
        this.setAttribute("recordModifiedBy", userId);
        return this;
    }

    public void addReference(String name, Message message) {
        AttributeDefinition attributeDefinition = this.messageModel.getAttributeDefinitionByName(name);
        if (attributeDefinition == null) {
            throw new RuntimeException("Message model does not contain a field with name:" + name);
        }
        if (attributeDefinition.getType() == AttributeType.OBJECT_SINGLE_REFERENCE) {
            this.setAttribute(name, message);
        } else if (attributeDefinition.getType() == AttributeType.OBJECT_MULTI_REFERENCE) {
            MessageAttribute messageAttribute = this.getAttribute(name);
            if (messageAttribute == null) {
                ArrayList<Message> messages = new ArrayList<Message>();
                messages.add(message);
                this.setAttribute(name, messages);
            } else {
                List<Message> referencedObjects = messageAttribute.getReferencedObjects();
                referencedObjects.add(message);
            }
        }
    }

    public void setAttribute(String name, Object value) {
        if (value == null && this.isEmpty(name)) {
            return;
        }
        AttributeDefinition attributeDefinition = this.messageModel.getAttributeDefinitionByName(name);
        if (attributeDefinition == null) {
            throw new RuntimeException("Message model does not contain a field with name:" + name);
        }
        MessageAttribute existingField = this.attributesByName.get(name);
        if (existingField != null) {
            this.attributes.remove(existingField);
            if (value != null) {
                MessageAttributeImpl messageAttribute = new MessageAttributeImpl(attributeDefinition, value);
                this.attributes.add(messageAttribute);
                this.attributesByName.put(name, messageAttribute);
            } else {
                this.attributesByName.remove(name);
            }
        } else if (value != null) {
            MessageAttributeImpl messageAttribute = new MessageAttributeImpl(attributeDefinition, value);
            this.attributes.add(messageAttribute);
            this.attributesByName.put(name, messageAttribute);
        }
    }

    public void removeField(AttributeDefinition attributeDefinition) {
        MessageAttribute existingField = this.attributesByName.get(attributeDefinition);
        if (existingField != null) {
            this.attributes.remove(existingField);
            this.attributesByName.remove(attributeDefinition);
        }
    }

    @Override
    public MessageAttribute getAttribute(String name) {
        return this.attributesByName.get(name);
    }

    protected String explain(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t".repeat(level)).append(this.messageModel.getName()).append(", ");
        sb.append("[").append(this.messageModel.getObjectUuid()).append("], ");
        for (MessageAttribute property : this.attributes) {
            sb.append("\n");
            sb.append(property.explain(level + 1));
        }
        return sb.toString();
    }

    public String toString() {
        return this.explain(0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return this.toString().equals(message.toString());
    }

    public int hashCode() {
        return Objects.hash(this.messageModel, this.attributes, this.attributesByName);
    }
}

