/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.message.protocol.message;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.teamapps.message.protocol.message.Message;
import org.teamapps.message.protocol.model.MessageModel;
import org.teamapps.message.protocol.model.ModelCollection;
import org.teamapps.message.protocol.model.ModelRegistry;
import org.teamapps.message.protocol.model.PojoObjectDecoder;
import org.teamapps.message.protocol.utils.MessageUtils;

public class MessageModelRegistry
implements ModelRegistry {
    private Map<String, List<MessageModel>> modelsByObjectUuid = new ConcurrentHashMap<String, List<MessageModel>>();
    private Map<String, MessageModel> latestModelByObjectUuid = new ConcurrentHashMap<String, MessageModel>();
    private Set<String> allModelKeys = new HashSet<String>();
    private List<MessageModel> allModels = new ArrayList<MessageModel>();
    private Map<String, PojoObjectDecoder<? extends Message>> decoderByUuid = new ConcurrentHashMap<String, PojoObjectDecoder<? extends Message>>();

    public MessageModelRegistry() {
    }

    public MessageModelRegistry(ModelCollection collection) {
        this.addModelCollection(collection);
    }

    @Override
    public void mergeRegistry(ModelRegistry registry) {
        registry.getAllModels().forEach(this::addModel);
    }

    @Override
    public List<MessageModel> getLatestModels() {
        return new ArrayList<MessageModel>(this.latestModelByObjectUuid.values());
    }

    @Override
    public List<MessageModel> getAllModels() {
        return new ArrayList<MessageModel>(this.allModels);
    }

    @Override
    public List<MessageModel> getModelVersions(String uuid) {
        return this.modelsByObjectUuid.get(uuid);
    }

    @Override
    public MessageModel getModel(String uuid, short modelVersion) {
        MessageModel messageModel = this.latestModelByObjectUuid.get(uuid);
        if (messageModel != null && messageModel.getModelVersion() == modelVersion) {
            return messageModel;
        }
        return null;
    }

    @Override
    public MessageModel getLatestModel(String uuid) {
        return this.latestModelByObjectUuid.get(uuid);
    }

    @Override
    public MessageModel getModel(byte[] message) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(message));
        String objectUuid = MessageUtils.readString(dis);
        short modelVersion = dis.readShort();
        return this.getModel(objectUuid, modelVersion);
    }

    @Override
    public ModelRegistry addModel(MessageModel model) {
        short modelVersion;
        String objectUuid = model.getObjectUuid();
        String key = objectUuid + (modelVersion = model.getModelVersion());
        if (this.allModelKeys.contains(key)) {
            return this;
        }
        this.allModelKeys.add(key);
        List<MessageModel> messageModels = this.modelsByObjectUuid.get(objectUuid);
        if (messageModels != null) {
            boolean contained = false;
            short lastVersion = 0;
            for (MessageModel messageModel : messageModels) {
                if (messageModel.getModelVersion() != modelVersion) continue;
                contained = true;
                lastVersion = (short)Math.max(lastVersion, messageModel.getModelVersion());
            }
            if (!contained) {
                messageModels.add(model);
                if (lastVersion < modelVersion) {
                    this.latestModelByObjectUuid.put(key, model);
                }
            }
        } else {
            messageModels = new ArrayList<MessageModel>();
            messageModels.add(model);
            this.modelsByObjectUuid.put(objectUuid, messageModels);
            this.latestModelByObjectUuid.put(objectUuid, model);
            this.allModels.add(model);
        }
        return this;
    }

    @Override
    public ModelRegistry addModelCollection(ModelCollection collection) {
        for (MessageModel model : collection.getModels()) {
            String modelUuid = model.getObjectUuid();
            PojoObjectDecoder<? extends Message> decoder = collection.getMessageDecoder(modelUuid);
            this.addModel(model);
            if (decoder == null) continue;
            this.addMessageDecoder(modelUuid, decoder);
        }
        return this;
    }

    @Override
    public PojoObjectDecoder<? extends Message> getMessageDecoder(String uuid) {
        return this.decoderByUuid.get(uuid);
    }

    @Override
    public boolean containsDecoder(String uuid) {
        return this.decoderByUuid.containsKey(uuid);
    }

    @Override
    public void addMessageDecoder(String uuid, PojoObjectDecoder<? extends Message> decoder) {
        this.decoderByUuid.put(uuid, decoder);
    }

    @Override
    public byte[] toBytes() {
        return new byte[0];
    }
}

