/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.message.protocol.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.teamapps.message.protocol.file.FileData;
import org.teamapps.message.protocol.file.FileDataType;
import org.teamapps.message.protocol.file.ProtectedFile;

public class LocalFileData
implements FileData {
    private final String fileName;
    private final long length;
    private final String path;
    private final boolean encrypted;
    private final String encryptionKey;

    public LocalFileData(String fileName, long length, String path) {
        this(fileName, length, path, false, null);
    }

    public LocalFileData(String fileName, long length, String path, boolean encrypted, String encryptionKey) {
        this.fileName = fileName;
        this.length = length;
        this.path = path;
        this.encrypted = encrypted;
        this.encryptionKey = encryptionKey;
        if (!new File(path).exists()) {
            throw new RuntimeException("Cannot create local file data for non existing file:" + path);
        }
    }

    @Override
    public FileDataType getType() {
        return FileDataType.LOCAL_FILE;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.path);
    }

    @Override
    public File getAsFile() {
        return new ProtectedFile(this.path);
    }

    @Override
    public String getDescriptor() {
        return this.path;
    }

    @Override
    public boolean isEncrypted() {
        return this.encrypted;
    }

    @Override
    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    @Override
    public String getBasePath() {
        return new File(this.path).getParentFile().getPath();
    }

    @Override
    public File copyToTempFile() throws IOException {
        File fileToCopy = new File(this.path);
        Path tempFile = Files.createTempFile("tmp", "." + this.getFileExtension(), new FileAttribute[0]);
        Files.copy(fileToCopy.toPath(), tempFile, StandardCopyOption.REPLACE_EXISTING);
        return tempFile.toFile();
    }

    @Override
    public void copyToFile(File file) throws IOException {
        File fileToCopy = new File(this.path);
        Files.copy(fileToCopy.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }
}

