/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.message.protocol.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.teamapps.message.protocol.model.EnumDefinition;
import org.teamapps.message.protocol.utils.MessageUtils;

public class EnumDefinitionImpl
implements EnumDefinition {
    private final String name;
    private final List<String> values;

    public EnumDefinitionImpl(String name, List<String> values) {
        this.name = name;
        this.values = values;
    }

    public EnumDefinitionImpl(byte[] bytes) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public EnumDefinitionImpl(DataInputStream dis) throws IOException {
        this.name = MessageUtils.readString(dis);
        this.values = new ArrayList<String>();
        int valueCount = dis.readInt();
        for (int i = 0; i < valueCount; ++i) {
            this.values.add(MessageUtils.readString(dis));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getEnumValues() {
        return this.values;
    }

    @Override
    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.write(dos);
        dos.close();
        return bos.toByteArray();
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        MessageUtils.writeString(dos, this.name);
        dos.writeInt(this.values.size());
        for (String value : this.values) {
            MessageUtils.writeString(dos, value);
        }
    }
}

