/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.message.protocol.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.teamapps.message.protocol.message.AbstractAttributeDefinition;
import org.teamapps.message.protocol.message.AttributeType;
import org.teamapps.message.protocol.message.DefinitionCache;
import org.teamapps.message.protocol.message.Message;
import org.teamapps.message.protocol.model.AttributeDefinition;
import org.teamapps.message.protocol.model.EnumDefinition;
import org.teamapps.message.protocol.model.ExtendedAttributesUpdater;
import org.teamapps.message.protocol.model.MessageModel;
import org.teamapps.message.protocol.utils.MessageUtils;

public class MessageDefinition
implements MessageModel {
    public static final String META_RECORD_ID = "recordId";
    public static final String META_CREATION_DATE = "recordCreationDate";
    public static final String META_CREATED_BY = "recordCreatedBy";
    public static final String META_MODIFICATION_DATE = "recordModificationDate";
    public static final String META_MODIFIED_BY = "recordModifiedBy";
    public static final Set<String> META_FIELD_NAMES = Stream.of("recordId", "recordCreationDate", "recordCreatedBy", "recordModificationDate", "recordModifiedBy").collect(Collectors.toSet());
    public static final Set<String> RESERVED_NAMES_LOWER_CASE = Stream.of("recordId", "recordCreationDate", "recordCreatedBy", "recordModificationDate", "recordModifiedBy").map(String::toLowerCase).collect(Collectors.toSet());
    private final String name;
    private final String comment;
    private final Message specificType;
    private final String objectUuid;
    private final short modelVersion;
    private final boolean messageRecord;
    private final List<AttributeDefinition> definitions = new ArrayList<AttributeDefinition>();
    private final Map<Integer, AttributeDefinition> definitionByKey = new HashMap<Integer, AttributeDefinition>();
    private final Map<String, AttributeDefinition> definitionByName = new HashMap<String, AttributeDefinition>();

    public static Message readBase64Message(String msg) {
        try {
            return msg == null ? null : new Message(Base64.getDecoder().decode(msg));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MessageDefinition(String objectUuid, String name, boolean messageRecord, int modelVersion) {
        this(objectUuid, name, null, messageRecord, modelVersion);
    }

    public MessageDefinition(String objectUuid, String name, Message specificType, boolean messageRecord, int modelVersion) {
        this(objectUuid, name, specificType, messageRecord, modelVersion, null);
    }

    public MessageDefinition(String objectUuid, String name, Message specificType, boolean messageRecord, int modelVersion, String comment) {
        this.objectUuid = objectUuid;
        this.name = name;
        this.specificType = specificType;
        this.modelVersion = (short)modelVersion;
        this.messageRecord = messageRecord;
        this.comment = comment;
        if (messageRecord) {
            this.addInteger(META_RECORD_ID, 16000);
            this.addTimestamp(META_CREATION_DATE, 16001);
            this.addInteger(META_CREATED_BY, 16002);
            this.addTimestamp(META_MODIFICATION_DATE, 16003);
            this.addInteger(META_MODIFIED_BY, 16004);
        }
    }

    public MessageDefinition(byte[] bytes) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public MessageDefinition(DataInputStream dis) throws IOException {
        this(dis, new DefinitionCache());
    }

    public MessageDefinition(DataInputStream dis, DefinitionCache definitionCache) throws IOException {
        this(MessageUtils.readString(dis), MessageUtils.readString(dis), MessageUtils.readMessageOrNull(dis), dis.readBoolean(), dis.readShort(), MessageUtils.readString(dis));
        definitionCache.addModel(this);
        int size = dis.readInt();
        for (int i = 0; i < size; ++i) {
            AbstractAttributeDefinition attributeDefinition = new AbstractAttributeDefinition((MessageModel)this, dis, definitionCache);
            if (attributeDefinition.getKey() >= 16000) continue;
            this.addAttribute(attributeDefinition);
        }
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        this.write(dos, new DefinitionCache());
    }

    @Override
    public void write(DataOutputStream dos, DefinitionCache definitionCache) throws IOException {
        MessageUtils.writeString(dos, this.objectUuid);
        MessageUtils.writeString(dos, this.getName());
        MessageUtils.writeNullableMessage(dos, this.getSpecificType());
        dos.writeBoolean(this.messageRecord);
        dos.writeShort(this.modelVersion);
        MessageUtils.writeString(dos, this.comment);
        dos.writeInt(this.definitions.size());
        for (AttributeDefinition attributeDefinition : this.definitions) {
            attributeDefinition.write(dos, definitionCache);
        }
    }

    @Override
    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.write(dos);
        dos.close();
        return bos.toByteArray();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Message getSpecificType() {
        return this.specificType;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public String getObjectUuid() {
        return this.objectUuid;
    }

    public ExtendedAttributesUpdater addBoolean(String name, int key) {
        return this.addAttribute(name, key, AttributeType.BOOLEAN);
    }

    public ExtendedAttributesUpdater addByte(String name, int key) {
        return this.addAttribute(name, key, AttributeType.BYTE);
    }

    public ExtendedAttributesUpdater addString(String name, int key) {
        return this.addAttribute(name, key, AttributeType.STRING);
    }

    public ExtendedAttributesUpdater addInteger(String name, int key) {
        return this.addAttribute(name, key, AttributeType.INT);
    }

    public ExtendedAttributesUpdater addLong(String name, int key) {
        return this.addAttribute(name, key, AttributeType.LONG);
    }

    public ExtendedAttributesUpdater addFloat(String name, int key) {
        return this.addAttribute(name, key, AttributeType.FLOAT);
    }

    public ExtendedAttributesUpdater addDouble(String name, int key) {
        return this.addAttribute(name, key, AttributeType.DOUBLE);
    }

    public ExtendedAttributesUpdater addFile(String name, int key) {
        return this.addAttribute(name, key, AttributeType.FILE);
    }

    public ExtendedAttributesUpdater addByteArray(String name, int key) {
        return this.addAttribute(name, key, AttributeType.BYTE_ARRAY);
    }

    public ExtendedAttributesUpdater addIntArray(String name, int key) {
        return this.addAttribute(name, key, AttributeType.INT_ARRAY);
    }

    public ExtendedAttributesUpdater addLongArray(String name, int key) {
        return this.addAttribute(name, key, AttributeType.LONG_ARRAY);
    }

    public ExtendedAttributesUpdater addFloatArray(String name, int key) {
        return this.addAttribute(name, key, AttributeType.FLOAT_ARRAY);
    }

    public ExtendedAttributesUpdater addDoubleArray(String name, int key) {
        return this.addAttribute(name, key, AttributeType.DOUBLE_ARRAY);
    }

    public ExtendedAttributesUpdater addStringArray(String name, int key) {
        return this.addAttribute(name, key, AttributeType.STRING_ARRAY);
    }

    public ExtendedAttributesUpdater addTimestamp(String name, int key) {
        return this.addAttribute(name, key, AttributeType.TIMESTAMP_32);
    }

    public ExtendedAttributesUpdater addLongTimestamp(String name, int key) {
        return this.addAttribute(name, key, AttributeType.TIMESTAMP_64);
    }

    public ExtendedAttributesUpdater addDateTime(String name, int key) {
        return this.addAttribute(name, key, AttributeType.DATE_TIME);
    }

    public ExtendedAttributesUpdater addDate(String name, int key) {
        return this.addAttribute(name, key, AttributeType.DATE);
    }

    public ExtendedAttributesUpdater addTime(String name, int key) {
        return this.addAttribute(name, key, AttributeType.TIME);
    }

    public ExtendedAttributesUpdater addEnum(String name, EnumDefinition enumDefinition, int key) {
        return this.addEnum(name, enumDefinition, key, null);
    }

    public ExtendedAttributesUpdater addEnum(String name, EnumDefinition enumDefinition, int key, Message specificType) {
        AbstractAttributeDefinition attributeDefinition = new AbstractAttributeDefinition((MessageModel)this, name, key, enumDefinition, specificType);
        this.addAttribute(attributeDefinition);
        return attributeDefinition;
    }

    public ExtendedAttributesUpdater addAttribute(String name, int key, AttributeType type) {
        return this.addAttribute(name, key, type, null);
    }

    public ExtendedAttributesUpdater addAttribute(String name, int key, AttributeType type, Message specificType) {
        AbstractAttributeDefinition attributeDefinition = new AbstractAttributeDefinition((MessageModel)this, name, key, type, specificType);
        this.addAttribute(attributeDefinition);
        return attributeDefinition;
    }

    public ExtendedAttributesUpdater addAttribute(String name, int key, AttributeType type, Message specificType, String defaultValue, String comment) {
        AbstractAttributeDefinition attributeDefinition = new AbstractAttributeDefinition((MessageModel)this, name, key, type, specificType, defaultValue, comment);
        this.addAttribute(attributeDefinition);
        return attributeDefinition;
    }

    public ExtendedAttributesUpdater addSingleReference(String name, MessageDefinition referencedObject, int key) {
        return this.addSingleReference(name, key, null, referencedObject);
    }

    public ExtendedAttributesUpdater addSingleReference(String name, int key, MessageDefinition referencedObject) {
        return this.addSingleReference(name, key, null, referencedObject);
    }

    public ExtendedAttributesUpdater addSingleReference(String name, int key, Message specificType, MessageDefinition referencedObject) {
        AbstractAttributeDefinition referenceAttributeDefinition = new AbstractAttributeDefinition(this, name, key, specificType, referencedObject, false);
        this.addAttribute(referenceAttributeDefinition);
        return referenceAttributeDefinition;
    }

    public ExtendedAttributesUpdater addMultiReference(String name, MessageDefinition referencedObject, int key) {
        return this.addMultiReference(name, key, null, referencedObject);
    }

    public ExtendedAttributesUpdater addMultiReference(String name, int key, MessageDefinition referencedObject) {
        return this.addMultiReference(name, key, null, referencedObject);
    }

    public ExtendedAttributesUpdater addMultiReference(String name, int key, Message specificType, MessageDefinition referencedObject) {
        AbstractAttributeDefinition referenceAttributeDefinition = new AbstractAttributeDefinition(this, name, key, specificType, referencedObject, true);
        this.addAttribute(referenceAttributeDefinition);
        return referenceAttributeDefinition;
    }

    public ExtendedAttributesUpdater addGenericMessage(String name, int key) {
        return this.addAttribute(name, key, AttributeType.GENERIC_MESSAGE);
    }

    public void addAttribute(AttributeDefinition field) {
        if (this.definitionByName.containsKey(field.getName()) || this.definitionByKey.containsKey(field.getKey())) {
            throw new RuntimeException("Object attribute already contains field with this name or key:" + field.getName() + "->" + field.getKey());
        }
        this.definitions.add(field);
        this.definitionByKey.put(field.getKey(), field);
        this.definitionByName.put(field.getName(), field);
    }

    @Override
    public boolean isMessageRecord() {
        return this.messageRecord;
    }

    @Override
    public short getModelVersion() {
        return this.modelVersion;
    }

    @Override
    public List<AttributeDefinition> getAttributeDefinitions() {
        return this.definitions;
    }

    @Override
    public AttributeDefinition getAttributeDefinitionByKey(int key) {
        return this.definitionByKey.get(key);
    }

    @Override
    public AttributeDefinition getAttributeDefinitionByName(String name) {
        return this.definitionByName.get(name);
    }

    @Override
    public String explain(int level, Set<String> printedObjects) {
        printedObjects.add(this.getObjectUuid());
        StringBuilder sb = new StringBuilder();
        sb.append("\t".repeat(level)).append(this.getName()).append(", ");
        sb.append("[").append(this.getObjectUuid()).append("], ");
        for (AttributeDefinition definition : this.definitions) {
            sb.append("\n");
            sb.append(definition.explain(level + 1, printedObjects));
        }
        return sb.toString();
    }

    public String toString() {
        return this.explain(0, new HashSet<String>());
    }
}

