/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.message.protocol.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.teamapps.message.protocol.message.MessageDefinition;
import org.teamapps.message.protocol.utils.MessageUtils;

public class ProtocolServiceBroadcastMethod {
    private final String methodName;
    private final MessageDefinition message;

    public ProtocolServiceBroadcastMethod(String methodName, MessageDefinition message) {
        this.methodName = methodName;
        this.message = message;
    }

    public ProtocolServiceBroadcastMethod(byte[] bytes) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public ProtocolServiceBroadcastMethod(DataInputStream dis) throws IOException {
        this.methodName = MessageUtils.readString(dis);
        this.message = new MessageDefinition(dis);
    }

    public MessageDefinition getMessage() {
        return this.message;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.write(dos);
        dos.close();
        return bos.toByteArray();
    }

    public void write(DataOutputStream dos) throws IOException {
        MessageUtils.writeString(dos, this.methodName);
        this.message.write(dos);
    }
}

