/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.message.protocol.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.teamapps.message.protocol.message.MessageDefinition;
import org.teamapps.message.protocol.utils.MessageUtils;

public class ProtocolServiceMethod {
    private final String methodName;
    private final MessageDefinition inputMessage;
    private final MessageDefinition outputMessage;

    public ProtocolServiceMethod(String methodName, MessageDefinition inputMessage, MessageDefinition outputMessage) {
        this.methodName = methodName;
        this.inputMessage = inputMessage;
        this.outputMessage = outputMessage;
    }

    public ProtocolServiceMethod(byte[] bytes) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public ProtocolServiceMethod(DataInputStream dis) throws IOException {
        this.methodName = MessageUtils.readString(dis);
        this.inputMessage = new MessageDefinition(dis);
        this.outputMessage = new MessageDefinition(dis);
    }

    public MessageDefinition getInputMessage() {
        return this.inputMessage;
    }

    public MessageDefinition getOutputMessage() {
        return this.outputMessage;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.write(dos);
        dos.close();
        return bos.toByteArray();
    }

    public void write(DataOutputStream dos) throws IOException {
        MessageUtils.writeString(dos, this.methodName);
        this.inputMessage.write(dos);
        this.outputMessage.write(dos);
    }
}

