/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.message.protocol.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.teamapps.message.protocol.message.MessageDefinition;
import org.teamapps.message.protocol.service.ProtocolServiceBroadcastMethod;
import org.teamapps.message.protocol.service.ProtocolServiceMethod;
import org.teamapps.message.protocol.utils.MessageUtils;

public class ServiceProtocol {
    private final String serviceName;
    private final List<ProtocolServiceMethod> serviceMethods = new ArrayList<ProtocolServiceMethod>();
    private final List<ProtocolServiceBroadcastMethod> broadcastMethods = new ArrayList<ProtocolServiceBroadcastMethod>();

    public ServiceProtocol(String serviceName) {
        this.serviceName = serviceName;
    }

    public ServiceProtocol(byte[] bytes) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public ServiceProtocol(DataInputStream dis) throws IOException {
        this.serviceName = MessageUtils.readString(dis);
        int serviceMethodCount = dis.readInt();
        for (int i = 0; i < serviceMethodCount; ++i) {
            this.serviceMethods.add(new ProtocolServiceMethod(dis));
        }
        int broadCastMethodCount = dis.readInt();
        for (int i = 0; i < broadCastMethodCount; ++i) {
            this.broadcastMethods.add(new ProtocolServiceBroadcastMethod(dis));
        }
    }

    public ServiceProtocol addMethod(ProtocolServiceMethod method) {
        this.serviceMethods.add(method);
        return this;
    }

    public ServiceProtocol addMethod(String methodName, MessageDefinition inputMessage, MessageDefinition outputMessage) {
        return this.addMethod(new ProtocolServiceMethod(methodName, inputMessage, outputMessage));
    }

    public ServiceProtocol addBroadcastMethod(String methodName, MessageDefinition message) {
        this.broadcastMethods.add(new ProtocolServiceBroadcastMethod(methodName, message));
        return this;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public List<ProtocolServiceMethod> getServiceMethods() {
        return this.serviceMethods;
    }

    public List<ProtocolServiceBroadcastMethod> getBroadcastMethods() {
        return this.broadcastMethods;
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.write(dos);
        dos.close();
        return bos.toByteArray();
    }

    public void write(DataOutputStream dos) throws IOException {
        MessageUtils.writeString(dos, this.serviceName);
        dos.writeInt(this.serviceMethods.size());
        for (ProtocolServiceMethod serviceMethod : this.serviceMethods) {
            serviceMethod.write(dos);
        }
        dos.writeInt(this.broadcastMethods.size());
        for (ProtocolServiceBroadcastMethod broadcastMethod : this.broadcastMethods) {
            broadcastMethod.write(dos);
        }
    }
}

