/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.message.protocol.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.teamapps.message.protocol.file.FileData;
import org.teamapps.message.protocol.file.FileDataType;
import org.teamapps.message.protocol.file.ProtectedFile;

public class GenericFileData
implements FileData {
    private final FileDataType type;
    private final String fileName;
    private final long length;
    private final String path;
    private final boolean encrypted;
    private final String encryptionKey;

    public GenericFileData(FileDataType type, String fileName, long length, String path) {
        this(type, fileName, length, path, false, null);
    }

    public GenericFileData(FileDataType type, String fileName, long length, String path, boolean encrypted, String encryptionKey) {
        this.type = type;
        this.fileName = fileName;
        this.length = length;
        this.path = path;
        this.encrypted = encrypted;
        this.encryptionKey = encryptionKey;
    }

    @Override
    public FileDataType getType() {
        return this.type;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.path);
    }

    @Override
    public File getAsFile() {
        return new ProtectedFile(this.path);
    }

    @Override
    public String getDescriptor() {
        return this.path;
    }

    @Override
    public boolean isEncrypted() {
        return this.encrypted;
    }

    @Override
    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    @Override
    public String getBasePath() {
        return new File(this.path).getParentFile().getPath();
    }
}

