/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.message.protocol.model;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Set;
import org.teamapps.message.protocol.message.AttributeType;
import org.teamapps.message.protocol.message.DefinitionCache;
import org.teamapps.message.protocol.message.MessageDefinition;
import org.teamapps.message.protocol.model.BaseDefinition;
import org.teamapps.message.protocol.model.EnumDefinition;
import org.teamapps.message.protocol.model.MessageModel;

public interface AttributeDefinition
extends BaseDefinition {
    public MessageModel getParent();

    public int getKey();

    public String getDefaultValue();

    public AttributeType getType();

    public MessageModel getReferencedObject();

    public EnumDefinition getEnumDefinition();

    public void write(DataOutputStream var1) throws IOException;

    public void write(DataOutputStream var1, DefinitionCache var2) throws IOException;

    public byte[] toBytes() throws IOException;

    public String explain(int var1, Set<String> var2);

    default public boolean isReferenceProperty() {
        return this.getType() == AttributeType.OBJECT_SINGLE_REFERENCE || this.getType() == AttributeType.OBJECT_MULTI_REFERENCE;
    }

    default public boolean isMultiReference() {
        return this.getType() == AttributeType.OBJECT_MULTI_REFERENCE;
    }

    default public boolean isEnumProperty() {
        return this.getType() == AttributeType.ENUM;
    }

    default public boolean isMetaDataField() {
        return MessageDefinition.META_FIELD_NAMES.contains(this.getName());
    }
}

