/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.message.protocol.service;

import org.teamapps.message.protocol.message.Message;
import org.teamapps.message.protocol.model.PojoObjectDecoder;
import org.teamapps.message.protocol.service.ClusterServiceRegistry;

public abstract class AbstractClusterServiceClient {
    private final ClusterServiceRegistry clusterServiceRegistry;
    private final String serviceName;

    public AbstractClusterServiceClient(ClusterServiceRegistry clusterServiceRegistry, String serviceName) {
        this.clusterServiceRegistry = clusterServiceRegistry;
        this.serviceName = serviceName;
    }

    protected <REQUEST extends Message, RESPONSE extends Message> RESPONSE executeClusterServiceMethod(String method, REQUEST request, PojoObjectDecoder<RESPONSE> responseDecoder) {
        return this.clusterServiceRegistry.executeServiceMethod(this.serviceName, method, request, responseDecoder);
    }

    protected <REQUEST extends Message, RESPONSE extends Message> RESPONSE executeClusterServiceMethod(String clusterNodeId, String method, REQUEST request, PojoObjectDecoder<RESPONSE> responseDecoder) {
        return this.clusterServiceRegistry.executeServiceMethod(clusterNodeId, this.serviceName, method, request, responseDecoder);
    }

    protected <MESSAGE extends Message> void executeServiceBroadcast(String method, MESSAGE message) {
        this.clusterServiceRegistry.executeServiceBroadcast(this.serviceName, method, message);
    }

    public boolean isAvailable() {
        return this.clusterServiceRegistry.isServiceAvailable(this.serviceName);
    }
}

