/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.message.protocol.builder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.IOUtils;
import org.teamapps.message.protocol.message.AttributeType;
import org.teamapps.message.protocol.message.MessageDefinition;
import org.teamapps.message.protocol.model.AttributeDefinition;
import org.teamapps.message.protocol.model.EnumDefinition;
import org.teamapps.message.protocol.model.MessageModel;
import org.teamapps.message.protocol.model.ModelCollection;
import org.teamapps.message.protocol.service.ProtocolServiceMethod;
import org.teamapps.message.protocol.service.ServiceProtocol;

public class MessagePojoBuilder {
    public static void createPojos(ModelCollection modelCollection, File directory) throws IOException {
        File dir = directory;
        String namespace = modelCollection.getNamespace();
        for (String name : namespace.split("\\.")) {
            dir = new File(dir, name);
            dir.mkdir();
        }
        System.out.println("Create source in path: " + dir.getPath());
        MessagePojoBuilder.createServiceClasses(modelCollection, dir);
        MessagePojoBuilder.createSchemaPojo(modelCollection, dir);
        for (MessageModel model : modelCollection.getModels()) {
            MessagePojoBuilder.createMessagePojoSave(modelCollection, model, dir);
        }
        for (EnumDefinition enumDefinition : modelCollection.getEnums()) {
            MessagePojoBuilder.createEnum(modelCollection, enumDefinition, dir);
        }
    }

    private static void createServiceClasses(ModelCollection modelCollection, File directory) throws IOException {
        for (ServiceProtocol serviceProtocol : modelCollection.getProtocolServiceSchemas()) {
            String tpl = MessagePojoBuilder.readTemplate("protocolService.tpl");
            tpl = MessagePojoBuilder.setValue(tpl, "package", modelCollection.getNamespace());
            String type = "Abstract" + MessagePojoBuilder.firstUpperCase(serviceProtocol.getServiceName());
            tpl = MessagePojoBuilder.setValue(tpl, "type", type);
            tpl = MessagePojoBuilder.setValue(tpl, "serviceName", serviceProtocol.getServiceName());
            StringBuilder data = new StringBuilder();
            StringBuilder cases = new StringBuilder();
            for (ProtocolServiceMethod method : serviceProtocol.getServiceMethods()) {
                String inputMessageName = method.getInputMessage().getName();
                data.append(MessagePojoBuilder.getTabs(1)).append("public abstract ").append(MessagePojoBuilder.firstUpperCase(method.getOutputMessage().getName())).append(" ").append(method.getMethodName()).append("(").append(MessagePojoBuilder.firstUpperCase(inputMessageName)).append(" value);\n\n");
                cases.append(MessagePojoBuilder.getTabs(3)).append("case \"").append(method.getMethodName()).append("\" -> {\n");
                cases.append(MessagePojoBuilder.getTabs(4)).append("return ").append(method.getMethodName()).append("(").append(MessagePojoBuilder.firstUpperCase(inputMessageName)).append(".remap(request));\n");
                cases.append(MessagePojoBuilder.getTabs(3)).append("}\n");
            }
            tpl = MessagePojoBuilder.setValue(tpl, "methods", data.toString());
            tpl = MessagePojoBuilder.setValue(tpl, "cases", cases.toString());
            File file = new File(directory, type + ".java");
            Files.writeString(file.toPath(), (CharSequence)tpl, new OpenOption[0]);
            type = MessagePojoBuilder.firstUpperCase(serviceProtocol.getServiceName()) + "Client";
            tpl = MessagePojoBuilder.readTemplate("protocolServiceClient.tpl");
            tpl = MessagePojoBuilder.setValue(tpl, "package", modelCollection.getNamespace());
            tpl = MessagePojoBuilder.setValue(tpl, "type", type);
            tpl = MessagePojoBuilder.setValue(tpl, "serviceName", serviceProtocol.getServiceName());
            data = new StringBuilder();
            for (ProtocolServiceMethod method : serviceProtocol.getServiceMethods()) {
                String inputMessageName = method.getInputMessage().getName();
                String outputMessageName = method.getOutputMessage().getName();
                data.append(MessagePojoBuilder.getTabs(1)).append("public ").append(MessagePojoBuilder.firstUpperCase(outputMessageName)).append(" ").append(method.getMethodName()).append("(").append(MessagePojoBuilder.firstUpperCase(inputMessageName)).append(" value) {\n");
                data.append(MessagePojoBuilder.getTabs(2)).append("return executeClusterServiceMethod(\"").append(method.getMethodName()).append("\", value, ").append(MessagePojoBuilder.firstUpperCase(outputMessageName)).append(".getMessageDecoder());\n");
                data.append(MessagePojoBuilder.getTabs(1)).append("}\n\n");
            }
            tpl = MessagePojoBuilder.setValue(tpl, "methods", data.toString());
            file = new File(directory, type + ".java");
            Files.writeString(file.toPath(), (CharSequence)tpl, new OpenOption[0]);
        }
    }

    private static void createSchemaPojo(ModelCollection modelCollection, File directory) throws IOException {
        String objName;
        String tpl = MessagePojoBuilder.readTemplate("messageCollection.tpl");
        tpl = MessagePojoBuilder.setValue(tpl, "package", modelCollection.getNamespace());
        tpl = MessagePojoBuilder.setValue(tpl, "type", MessagePojoBuilder.firstUpperCase(modelCollection.getName()));
        tpl = MessagePojoBuilder.setValue(tpl, "version", "" + modelCollection.getVersion());
        tpl = MessagePojoBuilder.setValue(tpl, "name", modelCollection.getName());
        StringBuilder data = new StringBuilder();
        StringBuilder registry = new StringBuilder();
        for (MessageModel model : modelCollection.getModels()) {
            objName = model.getName();
            data.append(MessagePojoBuilder.getTabs(2)).append("MessageDefinition ").append(objName).append(" = MODEL_COLLECTION.createModel(").append(MessagePojoBuilder.withQuotes(objName)).append(", ").append(MessagePojoBuilder.withQuotes(model.getObjectUuid())).append(", ").append(model.getModelVersion()).append(", ").append(MessagePojoBuilder.withQuotes(model.getSpecificType())).append(", ").append("" + model.isMessageRecord()).append(");\n");
        }
        data.append("\n");
        for (EnumDefinition enumDefinition : modelCollection.getEnums()) {
            objName = enumDefinition.getName();
            data.append(MessagePojoBuilder.getTabs(2)).append("EnumDefinition ").append(objName).append(" = MODEL_COLLECTION.createEnum(").append(MessagePojoBuilder.withQuotes(objName)).append(", ");
            for (int i = 0; i < enumDefinition.getEnumValues().size(); ++i) {
                String value = enumDefinition.getEnumValues().get(i);
                if (i > 0) {
                    data.append(", ");
                }
                data.append(MessagePojoBuilder.withQuotes(MessagePojoBuilder.createConstantName(value)));
            }
            data.append(");\n");
        }
        data.append("\n");
        for (MessageModel model : modelCollection.getModels()) {
            objName = model.getName();
            for (AttributeDefinition propDef : model.getAttributeDefinitions()) {
                if (model.isMessageRecord() && MessageDefinition.RESERVED_NAMES_LOWER_CASE.contains(propDef.getName().toLowerCase())) continue;
                if (propDef.isReferenceProperty()) {
                    String method = propDef.getType() == AttributeType.OBJECT_SINGLE_REFERENCE ? "addSingleReference" : "addMultiReference";
                    data.append(MessagePojoBuilder.getTabs(2)).append(objName).append(".").append(method).append("(").append(MessagePojoBuilder.withQuotes(propDef.getName())).append(", ").append(propDef.getKey()).append(", ").append(MessagePojoBuilder.withQuotes(propDef.getSpecificType())).append(", ").append(propDef.getReferencedObject().getName()).append(");\n");
                    continue;
                }
                if (propDef.isEnumProperty()) {
                    data.append(MessagePojoBuilder.getTabs(2)).append(objName).append(".addEnum(").append(MessagePojoBuilder.withQuotes(propDef.getName())).append(", ").append(propDef.getEnumDefinition().getName()).append(", ").append(propDef.getKey()).append(", ").append(MessagePojoBuilder.withQuotes(propDef.getSpecificType())).append(");\n");
                    continue;
                }
                data.append(MessagePojoBuilder.getTabs(2)).append(objName).append(".addAttribute(").append(MessagePojoBuilder.withQuotes(propDef.getName())).append(", ").append(propDef.getKey()).append(", ").append("AttributeType.").append((Object)propDef.getType()).append(", ").append(MessagePojoBuilder.withQuotes(propDef.getSpecificType())).append(");\n");
            }
            data.append("\n");
            registry.append(MessagePojoBuilder.getTabs(2)).append("MODEL_COLLECTION.addMessageDecoder(").append(objName).append(".getObjectUuid(), ").append(MessagePojoBuilder.firstUpperCase(objName)).append(".getMessageDecoder());\n");
        }
        tpl = MessagePojoBuilder.setValue(tpl, "data", data.toString());
        tpl = MessagePojoBuilder.setValue(tpl, "registry", registry.toString());
        File file = new File(directory, MessagePojoBuilder.firstUpperCase(modelCollection.getName()) + ".java");
        Files.writeString(file.toPath(), (CharSequence)tpl, new OpenOption[0]);
    }

    private static void createMessagePojoSave(ModelCollection modelCollection, MessageModel field, File directory) {
        try {
            MessagePojoBuilder.createMessagePojo(modelCollection, field, directory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void createEnum(ModelCollection modelCollection, EnumDefinition enumDefinition, File directory) throws IOException {
        String tpl = MessagePojoBuilder.readTemplate("enum.tpl");
        tpl = MessagePojoBuilder.setValue(tpl, "package", modelCollection.getNamespace());
        tpl = MessagePojoBuilder.setValue(tpl, "type", MessagePojoBuilder.firstUpperCase(enumDefinition.getName()));
        StringBuilder data = new StringBuilder();
        for (int i = 0; i < enumDefinition.getEnumValues().size(); ++i) {
            String value = enumDefinition.getEnumValues().get(i);
            data.append(MessagePojoBuilder.getTabs(1)).append(MessagePojoBuilder.createConstantName(value)).append("(").append(i + 1).append("),\n");
        }
        tpl = MessagePojoBuilder.setValue(tpl, "enums", data.toString());
        File file = new File(directory, MessagePojoBuilder.firstUpperCase(enumDefinition.getName()) + ".java");
        Files.writeString(file.toPath(), (CharSequence)tpl, new OpenOption[0]);
        System.out.println("Write enum:" + file.getPath());
    }

    private static void createMessagePojo(ModelCollection modelCollection, MessageModel model, File directory) throws IOException {
        String tpl = MessagePojoBuilder.readTemplate("messagePojo.tpl");
        tpl = MessagePojoBuilder.setValue(tpl, "package", modelCollection.getNamespace());
        tpl = MessagePojoBuilder.setValue(tpl, "type", MessagePojoBuilder.firstUpperCase(model.getName()));
        tpl = MessagePojoBuilder.setValue(tpl, "schema", MessagePojoBuilder.firstUpperCase(modelCollection.getName()));
        tpl = MessagePojoBuilder.setValue(tpl, "version", "" + model.getModelVersion());
        tpl = MessagePojoBuilder.setValue(tpl, "uuid", model.getObjectUuid());
        StringBuilder data = new StringBuilder();
        for (AttributeDefinition propDef : model.getAttributeDefinitions()) {
            if (model.isMessageRecord() && MessageDefinition.RESERVED_NAMES_LOWER_CASE.contains(propDef.getName().toLowerCase())) continue;
            if (propDef.getType() == AttributeType.ENUM) {
                data.append(MessagePojoBuilder.getTabs(1)).append("public ").append(MessagePojoBuilder.getReturnType(propDef)).append(" ").append("get").append(MessagePojoBuilder.firstUpperCase(propDef.getName())).append("() {\n").append(MessagePojoBuilder.getTabs(2)).append("int id = get").append(MessagePojoBuilder.getGetterSetterMethodName(propDef)).append("(").append(MessagePojoBuilder.withQuotes(propDef.getName())).append(");\n").append(MessagePojoBuilder.getTabs(2)).append("return id > 0 ? ").append(MessagePojoBuilder.firstUpperCase(propDef.getEnumDefinition().getName())).append(".values()[id - 1] : null;\n").append(MessagePojoBuilder.getTabs(1)).append("}\n\n");
                data.append(MessagePojoBuilder.getTabs(1)).append("public ").append(MessagePojoBuilder.firstUpperCase(model.getName())).append(" ").append("set").append(MessagePojoBuilder.firstUpperCase(propDef.getName())).append("(").append(MessagePojoBuilder.getReturnType(propDef)).append(" value) {\n").append(MessagePojoBuilder.getTabs(2)).append("set").append(MessagePojoBuilder.getGetterSetterMethodName(propDef)).append("(").append(MessagePojoBuilder.withQuotes(propDef.getName())).append(", value != null ? value.getId() : null);\n").append(MessagePojoBuilder.getTabs(2)).append("return this;\n").append(MessagePojoBuilder.getTabs(1)).append("}\n\n");
                continue;
            }
            String objectReferenceWithType = propDef.isReferenceProperty() ? "AsType" : "";
            data.append(MessagePojoBuilder.getTabs(1)).append("public ").append(MessagePojoBuilder.getReturnType(propDef)).append(" ").append(propDef.getType() == AttributeType.BOOLEAN ? "is" : "get").append(MessagePojoBuilder.firstUpperCase(propDef.getName())).append("() {\n").append(MessagePojoBuilder.getTabs(2)).append("return get").append(MessagePojoBuilder.getGetterSetterMethodName(propDef)).append(objectReferenceWithType).append("(").append(MessagePojoBuilder.withQuotes(propDef.getName())).append(");\n").append(MessagePojoBuilder.getTabs(1)).append("}\n\n");
            data.append(MessagePojoBuilder.getTabs(1)).append("public ").append(MessagePojoBuilder.firstUpperCase(model.getName())).append(" ").append("set").append(MessagePojoBuilder.firstUpperCase(propDef.getName())).append("(").append(MessagePojoBuilder.getReturnType(propDef)).append(" value) {\n").append(MessagePojoBuilder.getTabs(2)).append("set").append(MessagePojoBuilder.getGetterSetterMethodName(propDef)).append(objectReferenceWithType).append("(").append(MessagePojoBuilder.withQuotes(propDef.getName())).append(", value);\n").append(MessagePojoBuilder.getTabs(2)).append("return this;\n").append(MessagePojoBuilder.getTabs(1)).append("}\n\n");
            if (propDef.getType() == AttributeType.FILE) {
                data.append(MessagePojoBuilder.getTabs(1)).append("public String get").append(MessagePojoBuilder.firstUpperCase(propDef.getName())).append("AsFileName").append("() {\n").append(MessagePojoBuilder.getTabs(2)).append("return get").append("FileDataFileName").append("(").append(MessagePojoBuilder.withQuotes(propDef.getName())).append(");\n").append(MessagePojoBuilder.getTabs(1)).append("}\n\n");
                data.append(MessagePojoBuilder.getTabs(1)).append("public long get").append(MessagePojoBuilder.firstUpperCase(propDef.getName())).append("AsFileLength").append("() {\n").append(MessagePojoBuilder.getTabs(2)).append("return get").append("FileDataFileLength").append("(").append(MessagePojoBuilder.withQuotes(propDef.getName())).append(");\n").append(MessagePojoBuilder.getTabs(1)).append("}\n\n");
                data.append(MessagePojoBuilder.getTabs(1)).append("public ").append(MessagePojoBuilder.firstUpperCase(model.getName())).append(" ").append("set").append(MessagePojoBuilder.firstUpperCase(propDef.getName())).append("(").append("File").append(" value) {\n").append(MessagePojoBuilder.getTabs(2)).append("set").append(MessagePojoBuilder.getGetterSetterMethodName(propDef)).append("(").append(MessagePojoBuilder.withQuotes(propDef.getName())).append(", value);\n").append(MessagePojoBuilder.getTabs(2)).append("return this;\n").append(MessagePojoBuilder.getTabs(1)).append("}\n\n");
            }
            if (propDef.getType() == AttributeType.OBJECT_MULTI_REFERENCE) {
                data.append(MessagePojoBuilder.getTabs(1)).append("public ").append(MessagePojoBuilder.firstUpperCase(model.getName())).append(" ").append("add").append(MessagePojoBuilder.firstUpperCase(propDef.getName())).append("(").append(MessagePojoBuilder.firstUpperCase(propDef.getReferencedObject().getName())).append(" value) {\n").append(MessagePojoBuilder.getTabs(2)).append("addReference").append("(").append(MessagePojoBuilder.withQuotes(propDef.getName())).append(", value);\n").append(MessagePojoBuilder.getTabs(2)).append("return this;\n").append(MessagePojoBuilder.getTabs(1)).append("}\n\n");
            }
            if (propDef.getType() != AttributeType.STRING_ARRAY) continue;
        }
        tpl = MessagePojoBuilder.setValue(tpl, "methods", data.toString());
        File file = new File(directory, MessagePojoBuilder.firstUpperCase(model.getName()) + ".java");
        Files.writeString(file.toPath(), (CharSequence)tpl, new OpenOption[0]);
        System.out.println("Write pojo:" + file.getPath());
    }

    private static String readTemplate(String name) throws IOException {
        InputStream inputStream = MessagePojoBuilder.class.getResourceAsStream("/org/teamapps/message/templates/" + name);
        return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
    }

    private static String setValue(String template, String name, String value) {
        return template.replace("{" + name + "}", value);
    }

    private static String firstUpperCase(String value) {
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    private static String createConstantName(String s) {
        if (MessagePojoBuilder.isConstant(s)) {
            return s;
        }
        return s.replaceAll("(.)(\\p{Upper})", "$1_$2").toUpperCase();
    }

    private static boolean isConstant(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_' || Character.isUpperCase(c) || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    private static String getTabs(int count) {
        return "\t".repeat(count);
    }

    private static String withQuotes(String value) {
        return value != null ? "\"" + value + "\"" : "null";
    }

    private static String getReturnType(AttributeDefinition propDef) {
        return switch (propDef.getType()) {
            case AttributeType.OBJECT -> MessagePojoBuilder.firstUpperCase(propDef.getName());
            case AttributeType.OBJECT_SINGLE_REFERENCE -> MessagePojoBuilder.firstUpperCase(propDef.getReferencedObject().getName());
            case AttributeType.OBJECT_MULTI_REFERENCE -> "List<" + MessagePojoBuilder.firstUpperCase(propDef.getReferencedObject().getName()) + ">";
            case AttributeType.BOOLEAN -> "boolean";
            case AttributeType.BYTE -> "byte";
            case AttributeType.INT -> "int";
            case AttributeType.LONG -> "long";
            case AttributeType.FLOAT -> "float";
            case AttributeType.DOUBLE -> "double";
            case AttributeType.STRING -> "String";
            case AttributeType.BITSET -> "BitSet";
            case AttributeType.BYTE_ARRAY -> "byte[]";
            case AttributeType.INT_ARRAY -> "int[]";
            case AttributeType.LONG_ARRAY -> "long[]";
            case AttributeType.FLOAT_ARRAY -> "float[]";
            case AttributeType.DOUBLE_ARRAY -> "double[]";
            case AttributeType.STRING_ARRAY -> "String[]";
            case AttributeType.FILE -> "FileData";
            case AttributeType.ENUM -> MessagePojoBuilder.firstUpperCase(propDef.getEnumDefinition().getName());
            case AttributeType.TIMESTAMP_32 -> "Instant";
            case AttributeType.TIMESTAMP_64 -> "Instant";
            case AttributeType.DATE_TIME -> "LocalDateTime";
            case AttributeType.DATE -> "LocalDate";
            case AttributeType.TIME -> "LocalTime";
            case AttributeType.GENERIC_MESSAGE -> "Message";
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private static String getGetterSetterMethodName(AttributeDefinition propDef) {
        return switch (propDef.getType()) {
            case AttributeType.OBJECT -> "Message";
            case AttributeType.OBJECT_SINGLE_REFERENCE -> "ReferencedObject";
            case AttributeType.OBJECT_MULTI_REFERENCE -> "ReferencedObjects";
            case AttributeType.BOOLEAN -> "BooleanAttribute";
            case AttributeType.BYTE -> "ByteAttribute";
            case AttributeType.INT -> "IntAttribute";
            case AttributeType.LONG -> "LongAttribute";
            case AttributeType.FLOAT -> "FloatAttribute";
            case AttributeType.DOUBLE -> "DoubleAttribute";
            case AttributeType.STRING -> "StringAttribute";
            case AttributeType.BITSET -> "BitSetAttribute";
            case AttributeType.BYTE_ARRAY -> "ByteArrayAttribute";
            case AttributeType.INT_ARRAY -> "IntArrayAttribute";
            case AttributeType.LONG_ARRAY -> "LongArrayAttribute";
            case AttributeType.FLOAT_ARRAY -> "FloatArrayAttribute";
            case AttributeType.DOUBLE_ARRAY -> "DoubleArrayAttribute";
            case AttributeType.STRING_ARRAY -> "StringArrayAttribute";
            case AttributeType.FILE -> "FileData";
            case AttributeType.ENUM -> "IntAttribute";
            case AttributeType.TIMESTAMP_32 -> "TimestampAttribute";
            case AttributeType.TIMESTAMP_64 -> "TimestampAttribute";
            case AttributeType.DATE_TIME -> "DateTimeAttribute";
            case AttributeType.DATE -> "DateAttribute";
            case AttributeType.TIME -> "TimeAttribute";
            case AttributeType.GENERIC_MESSAGE -> "GenericMessageAttribute";
            default -> throw new IncompatibleClassChangeError();
        };
    }
}

