/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.message.protocol.message;

import java.util.HashMap;
import java.util.Map;
import org.teamapps.message.protocol.model.EnumDefinition;
import org.teamapps.message.protocol.model.MessageModel;

public class DefinitionCache {
    private final Map<String, MessageModel> modelCache = new HashMap<String, MessageModel>();
    private final Map<String, EnumDefinition> enumCache = new HashMap<String, EnumDefinition>();

    public void addModel(MessageModel model) {
        this.modelCache.put(model.getObjectUuid(), model);
    }

    public boolean containsModel(MessageModel model) {
        return this.modelCache.containsKey(model.getObjectUuid());
    }

    public MessageModel getModel(String uuid) {
        return this.modelCache.get(uuid);
    }

    public void addEnum(EnumDefinition enumDefinition) {
        this.enumCache.put(enumDefinition.getName(), enumDefinition);
    }

    public EnumDefinition getEnum(String name) {
        return this.enumCache.get(name);
    }

    public boolean containsEnum(EnumDefinition enumDefinition) {
        return this.enumCache.containsKey(enumDefinition.getName());
    }
}

