/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.message.protocol.service;

import java.util.ArrayList;
import java.util.List;
import org.teamapps.message.protocol.message.MessageDefinition;
import org.teamapps.message.protocol.service.ProtocolServiceMethod;

public class ServiceProtocol {
    private final String serviceName;
    private final List<ProtocolServiceMethod> serviceMethods = new ArrayList<ProtocolServiceMethod>();

    public ServiceProtocol(String serviceName) {
        this.serviceName = serviceName;
    }

    public ServiceProtocol addMethod(ProtocolServiceMethod method) {
        this.serviceMethods.add(method);
        return this;
    }

    public ServiceProtocol addMethod(String methodName, MessageDefinition inputMessage, MessageDefinition outputMessage) {
        return this.addMethod(new ProtocolServiceMethod(methodName, inputMessage, outputMessage));
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public List<ProtocolServiceMethod> getServiceMethods() {
        return this.serviceMethods;
    }
}

