/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.message.protocol.utils;

import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.message.protocol.message.AttributeType;

public class StringUtils {
    public static Object readFromString(String s, AttributeType type) {
        if (s == null || s.isBlank()) {
            return null;
        }
        return switch (type) {
            case AttributeType.BOOLEAN -> s.equals("1") || s.equalsIgnoreCase("true");
            case AttributeType.BYTE -> Integer.parseInt(s);
            case AttributeType.INT -> Integer.parseInt(s);
            case AttributeType.LONG -> Long.parseLong(s);
            case AttributeType.FLOAT -> Float.valueOf(Float.parseFloat(s));
            case AttributeType.DOUBLE -> Double.parseDouble(s);
            case AttributeType.STRING -> s;
            case AttributeType.BITSET -> null;
            case AttributeType.BYTE_ARRAY -> (Object)Base64.getDecoder().decode(s);
            case AttributeType.INT_ARRAY -> (Object)StringUtils.readArray(s).stream().mapToInt(Integer::parseInt).toArray();
            case AttributeType.LONG_ARRAY -> (Object)StringUtils.readArray(s).stream().mapToLong(Long::parseLong).toArray();
            case AttributeType.FLOAT_ARRAY -> null;
            case AttributeType.DOUBLE_ARRAY -> (Object)StringUtils.readArray(s).stream().mapToDouble(Double::parseDouble).toArray();
            case AttributeType.STRING_ARRAY -> StringUtils.readArray(s).toArray(new String[0]);
            case AttributeType.ENUM -> null;
            case AttributeType.TIMESTAMP_32 -> null;
            case AttributeType.TIMESTAMP_64 -> null;
            case AttributeType.DATE_TIME -> null;
            case AttributeType.DATE -> null;
            case AttributeType.TIME -> null;
            case AttributeType.GENERIC_MESSAGE -> null;
            default -> null;
        };
    }

    private static List<String> readArray(String s) {
        return Arrays.stream(s.split(",")).map(String::trim).collect(Collectors.toList());
    }
}

