/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.message.protocol.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.teamapps.message.protocol.file.FileDataType;
import org.teamapps.message.protocol.file.LocalFileData;

public interface FileData {
    public static FileData create(File file) {
        return new LocalFileData(file.getName(), file.length(), file.getPath());
    }

    public static FileData create(File file, String fileName) {
        return new LocalFileData(fileName, file.length(), file.getPath());
    }

    public FileDataType getType();

    public String getFileName();

    public long getLength();

    public InputStream getInputStream() throws IOException;

    public String getDescriptor();

    public boolean isEncrypted();

    public String getEncryptionKey();

    public String getBasePath();

    default public String getFileExtension() {
        String name = this.getFileName();
        int pos = name.lastIndexOf(46);
        return pos > 0 ? name.substring(pos).toLowerCase() : "tmp";
    }

    default public File copyToTempFile() throws IOException {
        Path path = Files.createTempFile("tmp", "." + this.getFileExtension(), new FileAttribute[0]);
        Files.copy(this.getInputStream(), path, StandardCopyOption.REPLACE_EXISTING);
        return path.toFile();
    }

    default public void copyToFile(File file) throws IOException {
        Files.copy(this.getInputStream(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    default public byte[] toBytes() throws IOException {
        if (this.getLength() > 1000000000L) {
            throw new RuntimeException("File too large for byte array:" + this.getLength());
        }
        BufferedInputStream bis = new BufferedInputStream(this.getInputStream());
        return IOUtils.readFully((InputStream)bis, (int)((int)this.getLength()));
    }
}

