/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.message.protocol.message;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.teamapps.message.protocol.file.FileData;
import org.teamapps.message.protocol.file.FileDataReader;
import org.teamapps.message.protocol.file.FileDataWriter;
import org.teamapps.message.protocol.message.AbstractAttributeDefinition;
import org.teamapps.message.protocol.message.AttributeType;
import org.teamapps.message.protocol.message.Message;
import org.teamapps.message.protocol.message.MessageAttribute;
import org.teamapps.message.protocol.model.AttributeDefinition;
import org.teamapps.message.protocol.model.MessageModel;
import org.teamapps.message.protocol.model.ModelCollection;
import org.teamapps.message.protocol.model.PojoObjectDecoder;
import org.teamapps.message.protocol.model.PojoObjectDecoderRegistry;
import org.teamapps.message.protocol.utils.MessageUtils;
import org.teamapps.message.protocol.xml.XmlNode;
import org.teamapps.message.protocol.xml.XmlUtils;
import org.w3c.dom.Element;

public class MessageAttributeImpl
implements MessageAttribute {
    private final AttributeDefinition attributeDefinition;
    private final Object value;

    public MessageAttributeImpl(AttributeDefinition attributeDefinition, Object value) {
        this.attributeDefinition = attributeDefinition;
        this.value = value;
    }

    public MessageAttributeImpl(MessageAttributeImpl attribute, AttributeDefinition remappedDefinition, ModelCollection modelCollection) {
        this.attributeDefinition = remappedDefinition;
        if (this.attributeDefinition.isReferenceProperty()) {
            MessageModel referencedObjectDefinition = this.attributeDefinition.getReferencedObject();
            PojoObjectDecoder<? extends Message> messageDecoder = modelCollection.getMessageDecoder(referencedObjectDefinition.getObjectUuid());
            if (this.attributeDefinition.isMultiReference()) {
                List messages = (List)attribute.value;
                ArrayList<Message> remappedMessages = new ArrayList<Message>();
                for (Message message : messages) {
                    remappedMessages.add(messageDecoder.remap(message));
                }
                this.value = remappedMessages;
            } else {
                Message message = (Message)attribute.value;
                this.value = messageDecoder.remap(message);
            }
        } else {
            this.value = attribute.value;
        }
    }

    public MessageAttributeImpl(DataInputStream dis, MessageModel model, FileDataReader fileDataReader, PojoObjectDecoderRegistry decoderRegistry) throws IOException {
        AttributeDefinition modelDef;
        AttributeType type = AttributeType.getById(dis.readByte());
        short key = dis.readShort();
        AttributeDefinition attributeDefinition = modelDef = model == null ? null : model.getAttributeDefinitionByKey(key);
        if (modelDef == null) {
            if (type.isReference()) {
                if (type == AttributeType.OBJECT_SINGLE_REFERENCE) {
                    Message message = new Message(dis, fileDataReader);
                    MessageModel definition = message.getModel();
                    this.attributeDefinition = new AbstractAttributeDefinition(model, null, key, null, definition, false);
                    this.value = message;
                } else {
                    ArrayList<Message> messages = new ArrayList<Message>();
                    int messageCount = dis.readInt();
                    MessageModel definition = null;
                    for (int i = 0; i < messageCount; ++i) {
                        Message message = new Message(dis, fileDataReader);
                        if (definition == null) {
                            definition = message.getModel();
                        }
                        messages.add(message);
                    }
                    this.attributeDefinition = new AbstractAttributeDefinition(model, null, key, null, definition, true);
                    this.value = messages;
                }
            } else {
                this.attributeDefinition = new AbstractAttributeDefinition(model, null, (int)key, type, null);
                this.value = this.readValue(dis, this.attributeDefinition.getType(), fileDataReader);
            }
        } else {
            this.attributeDefinition = modelDef;
            if (type != this.attributeDefinition.getType()) {
                throw new RuntimeException("Message parsing error - property type mismatch: " + String.valueOf((Object)type) + " <-> " + String.valueOf((Object)this.attributeDefinition.getType()));
            }
            if (this.attributeDefinition.getType().isReference()) {
                if (type == AttributeType.OBJECT_SINGLE_REFERENCE) {
                    MessageModel referencedObjectDefinition = this.attributeDefinition.getReferencedObject();
                    if (decoderRegistry != null && decoderRegistry.containsDecoder(referencedObjectDefinition.getObjectUuid())) {
                        PojoObjectDecoder<? extends Message> messageDecoder = decoderRegistry.getMessageDecoder(referencedObjectDefinition.getObjectUuid());
                        this.value = messageDecoder.decode(dis, fileDataReader);
                    } else {
                        this.value = new Message(dis, referencedObjectDefinition, fileDataReader, decoderRegistry);
                    }
                } else {
                    MessageModel referencedObjectDefinition = this.attributeDefinition.getReferencedObject();
                    ArrayList<Message> messages = new ArrayList<Message>();
                    int messageCount = dis.readInt();
                    if (decoderRegistry != null && decoderRegistry.containsDecoder(referencedObjectDefinition.getObjectUuid())) {
                        PojoObjectDecoder<? extends Message> messageDecoder = decoderRegistry.getMessageDecoder(referencedObjectDefinition.getObjectUuid());
                        for (int i = 0; i < messageCount; ++i) {
                            messages.add(messageDecoder.decode(dis, fileDataReader));
                        }
                    } else {
                        for (int i = 0; i < messageCount; ++i) {
                            messages.add(new Message(dis, referencedObjectDefinition, fileDataReader, decoderRegistry));
                        }
                    }
                    this.value = messages;
                }
            } else {
                this.value = this.readValue(dis, this.attributeDefinition.getType(), fileDataReader);
            }
        }
    }

    public MessageAttributeImpl(Element element, AttributeDefinition definition, FileDataReader fileDataReader, PojoObjectDecoderRegistry decoderRegistry) {
        this.attributeDefinition = definition;
        AttributeType type = definition.getType();
        if (type.isReference()) {
            if (type == AttributeType.OBJECT_SINGLE_REFERENCE) {
                MessageModel referencedObjectDefinition = definition.getReferencedObject();
                Element refElement = XmlUtils.readChildElement(element, referencedObjectDefinition.getName());
                if (refElement == null || !referencedObjectDefinition.getName().equals(refElement.getNodeName())) {
                    throw new RuntimeException("Wrong element name, expected:" + referencedObjectDefinition.getName() + ", actual:" + refElement.getNodeName());
                }
                if (decoderRegistry != null && decoderRegistry.containsDecoder(referencedObjectDefinition.getObjectUuid())) {
                    PojoObjectDecoder<? extends Message> messageDecoder = decoderRegistry.getMessageDecoder(referencedObjectDefinition.getObjectUuid());
                    this.value = messageDecoder.decode(refElement, fileDataReader);
                } else {
                    this.value = new Message(refElement, referencedObjectDefinition, fileDataReader, decoderRegistry);
                }
            } else {
                MessageModel referencedObjectDefinition = definition.getReferencedObject();
                ArrayList<Message> messages = new ArrayList<Message>();
                List<Element> multiChildNodes = XmlUtils.readChildrenElements(element, referencedObjectDefinition.getName());
                int messageCount = multiChildNodes.size();
                if (decoderRegistry != null && decoderRegistry.containsDecoder(referencedObjectDefinition.getObjectUuid())) {
                    PojoObjectDecoder<? extends Message> messageDecoder = decoderRegistry.getMessageDecoder(referencedObjectDefinition.getObjectUuid());
                    for (int i = 0; i < messageCount; ++i) {
                        messages.add(messageDecoder.decode(multiChildNodes.get(i), fileDataReader));
                    }
                } else {
                    for (int i = 0; i < messageCount; ++i) {
                        messages.add(new Message(multiChildNodes.get(i), referencedObjectDefinition, fileDataReader, decoderRegistry));
                    }
                }
                this.value = messages;
            }
        } else {
            this.value = this.readValue(element, type, fileDataReader);
        }
    }

    private Object readValue(DataInputStream dis, AttributeType type, FileDataReader fileDataReader) throws IOException {
        return switch (this.attributeDefinition.getType()) {
            case AttributeType.BOOLEAN -> dis.readBoolean();
            case AttributeType.BYTE -> dis.readByte();
            case AttributeType.INT, AttributeType.ENUM -> dis.readInt();
            case AttributeType.LONG -> dis.readLong();
            case AttributeType.FLOAT -> Float.valueOf(dis.readFloat());
            case AttributeType.DOUBLE -> dis.readDouble();
            case AttributeType.STRING -> MessageUtils.readString(dis);
            case AttributeType.BITSET -> MessageUtils.readBitSet(dis);
            case AttributeType.BYTE_ARRAY -> (Object)MessageUtils.readByteArray(dis);
            case AttributeType.INT_ARRAY -> (Object)MessageUtils.readIntArray(dis);
            case AttributeType.LONG_ARRAY -> (Object)MessageUtils.readLongArray(dis);
            case AttributeType.FLOAT_ARRAY -> (Object)MessageUtils.readFloatArray(dis);
            case AttributeType.DOUBLE_ARRAY -> (Object)MessageUtils.readDoubleArray(dis);
            case AttributeType.STRING_ARRAY -> MessageUtils.readStringArray(dis);
            case AttributeType.FILE -> MessageUtils.readFile(dis, fileDataReader);
            case AttributeType.TIMESTAMP_32 -> MessageUtils.readInstant32(dis);
            case AttributeType.TIMESTAMP_64 -> MessageUtils.readInstant64(dis);
            case AttributeType.DATE_TIME -> MessageUtils.readLocalDateTime(dis);
            case AttributeType.DATE -> MessageUtils.readLocalDate(dis);
            case AttributeType.TIME -> MessageUtils.readLocalTime(dis);
            case AttributeType.GENERIC_MESSAGE -> MessageUtils.readGenericMessage(dis, fileDataReader);
            default -> throw new RuntimeException("Message parsing error - property type unknown:" + String.valueOf((Object)this.attributeDefinition.getType()));
        };
    }

    private Object readValue(Element element, AttributeType type, FileDataReader fileDataReader) {
        return switch (this.attributeDefinition.getType()) {
            case AttributeType.BOOLEAN -> XmlUtils.readBoolean(element);
            case AttributeType.BYTE -> XmlUtils.readByte(element);
            case AttributeType.INT, AttributeType.ENUM -> XmlUtils.readInt(element);
            case AttributeType.LONG -> XmlUtils.readLong(element);
            case AttributeType.FLOAT -> Float.valueOf(XmlUtils.readFloat(element));
            case AttributeType.DOUBLE -> XmlUtils.readDouble(element);
            case AttributeType.STRING -> XmlUtils.readString(element);
            case AttributeType.BITSET -> XmlUtils.readBitSet(element);
            case AttributeType.BYTE_ARRAY -> (Object)XmlUtils.readByteArray(element);
            case AttributeType.INT_ARRAY -> (Object)XmlUtils.readIntArray(element);
            case AttributeType.LONG_ARRAY -> (Object)XmlUtils.readLongArray(element);
            case AttributeType.FLOAT_ARRAY -> (Object)XmlUtils.readFloatArray(element);
            case AttributeType.DOUBLE_ARRAY -> (Object)XmlUtils.readDoubleArray(element);
            case AttributeType.STRING_ARRAY -> XmlUtils.readStringArray(element);
            case AttributeType.FILE -> XmlUtils.readFile(element, fileDataReader);
            case AttributeType.TIMESTAMP_32 -> XmlUtils.readInstant32(element);
            case AttributeType.TIMESTAMP_64 -> XmlUtils.readInstant64(element);
            case AttributeType.DATE_TIME -> XmlUtils.readLocalDateTime(element);
            case AttributeType.DATE -> XmlUtils.readLocalDate(element);
            case AttributeType.TIME -> XmlUtils.readLocalTime(element);
            case AttributeType.GENERIC_MESSAGE -> XmlUtils.readGenericMessage(element, fileDataReader);
            default -> throw new RuntimeException("Message parsing error - property type unknown:" + String.valueOf((Object)this.attributeDefinition.getType()));
        };
    }

    @Override
    public void write(DataOutputStream dos, FileDataWriter fileDataWriter) throws IOException {
        dos.writeByte(this.attributeDefinition.getType().getId());
        dos.writeShort(this.attributeDefinition.getKey());
        switch (this.attributeDefinition.getType()) {
            case OBJECT_SINGLE_REFERENCE: {
                Message referencedObject = this.getReferencedObject();
                referencedObject.write(dos, fileDataWriter);
                break;
            }
            case OBJECT_MULTI_REFERENCE: {
                List<Message> referencedObjects = this.getReferencedObjects();
                if (referencedObjects == null || referencedObjects.isEmpty()) {
                    dos.writeInt(0);
                    break;
                }
                dos.writeInt(referencedObjects.size());
                for (Message referencedObject : referencedObjects) {
                    referencedObject.write(dos, fileDataWriter);
                }
                break;
            }
            case BOOLEAN: {
                dos.writeBoolean(this.getBooleanAttribute());
                break;
            }
            case BYTE: {
                dos.writeByte(this.getByteAttribute());
                break;
            }
            case INT: 
            case ENUM: {
                dos.writeInt(this.getIntAttribute());
                break;
            }
            case LONG: {
                dos.writeLong(this.getLongAttribute());
                break;
            }
            case FLOAT: {
                dos.writeFloat(this.getFloatAttribute());
                break;
            }
            case DOUBLE: {
                dos.writeDouble(this.getDoubleAttribute());
                break;
            }
            case STRING: {
                MessageUtils.writeString(dos, this.getStringAttribute());
                break;
            }
            case BITSET: {
                MessageUtils.writeBitSet(dos, this.getBitSetAttribute());
                break;
            }
            case BYTE_ARRAY: {
                MessageUtils.writeByteArray(dos, this.getByteArrayAttribute());
                break;
            }
            case INT_ARRAY: {
                MessageUtils.writeIntArray(dos, this.getIntArrayAttribute());
                break;
            }
            case LONG_ARRAY: {
                MessageUtils.writeLongArray(dos, this.getLongArrayAttribute());
                break;
            }
            case FLOAT_ARRAY: {
                MessageUtils.writeFloatArray(dos, this.getFloatArrayAttribute());
                break;
            }
            case DOUBLE_ARRAY: {
                MessageUtils.writeDoubleArray(dos, this.getDoubleArrayAttribute());
                break;
            }
            case STRING_ARRAY: {
                MessageUtils.writeStringArray(dos, this.getStringArrayAttribute());
                break;
            }
            case FILE: {
                MessageUtils.writeFile(dos, this.getFileData(), fileDataWriter);
                break;
            }
            case TIMESTAMP_32: {
                MessageUtils.writeInstant32(dos, this.getTimestampAttribute());
                break;
            }
            case TIMESTAMP_64: {
                MessageUtils.writeInstant64(dos, this.getTimestampAttribute());
                break;
            }
            case DATE_TIME: {
                MessageUtils.writeLocalDateTime(dos, this.getDateTimeAttribute());
                break;
            }
            case DATE: {
                MessageUtils.writeLocalDate(dos, this.getDateAttribute());
                break;
            }
            case TIME: {
                MessageUtils.writeLocalTime(dos, this.getTimeAttribute());
                break;
            }
            case GENERIC_MESSAGE: {
                MessageUtils.writeGenericMessage(dos, this.getGenericMessageAttribute(), fileDataWriter);
            }
        }
    }

    @Override
    public byte[] toBytes() throws IOException {
        return this.toBytes(null);
    }

    @Override
    public byte[] toBytes(FileDataWriter fileDataWriter) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.write(dos, fileDataWriter);
        dos.close();
        return bos.toByteArray();
    }

    protected void toXml(XmlNode parentNode, FileDataWriter fileDataWriter) throws IOException {
        XmlNode xmlNode = new XmlNode(this.attributeDefinition.getName());
        parentNode.addChild(xmlNode);
        block0 : switch (this.attributeDefinition.getType()) {
            case OBJECT_SINGLE_REFERENCE: {
                Message referencedObject = this.getReferencedObject();
                referencedObject.toXml(xmlNode, fileDataWriter);
                break;
            }
            case OBJECT_MULTI_REFERENCE: {
                List<Message> referencedObjects = this.getReferencedObjects();
                if (referencedObjects == null) break;
                for (Message referencedObject : referencedObjects) {
                    referencedObject.toXml(xmlNode, fileDataWriter);
                }
                break;
            }
            default: {
                if (this.value == null) break;
                switch (this.attributeDefinition.getType()) {
                    case INT: 
                    case ENUM: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case STRING: {
                        xmlNode.setValue(this.value.toString());
                        break block0;
                    }
                    case BOOLEAN: {
                        XmlUtils.writeBoolean(xmlNode, this.getBooleanAttribute());
                        break block0;
                    }
                    case BYTE: {
                        XmlUtils.writeByte(xmlNode, this.getByteAttribute());
                        break block0;
                    }
                    case BITSET: {
                        XmlUtils.writeBitSet(xmlNode, this.getBitSetAttribute());
                        break block0;
                    }
                    case BYTE_ARRAY: {
                        XmlUtils.writeByteArray(xmlNode, this.getByteArrayAttribute());
                        break block0;
                    }
                    case INT_ARRAY: {
                        XmlUtils.writeIntArray(xmlNode, this.getIntArrayAttribute());
                        break block0;
                    }
                    case LONG_ARRAY: {
                        XmlUtils.writeLongArray(xmlNode, this.getLongArrayAttribute());
                        break block0;
                    }
                    case FLOAT_ARRAY: {
                        XmlUtils.writeFloatArray(xmlNode, this.getFloatArrayAttribute());
                        break block0;
                    }
                    case DOUBLE_ARRAY: {
                        XmlUtils.writeDoubleArray(xmlNode, this.getDoubleArrayAttribute());
                        break block0;
                    }
                    case STRING_ARRAY: {
                        XmlUtils.writeStringArray(xmlNode, this.getStringArrayAttribute());
                        break block0;
                    }
                    case FILE: {
                        XmlUtils.writeFile(xmlNode, this.getFileData(), fileDataWriter);
                        break block0;
                    }
                    case TIMESTAMP_32: {
                        XmlUtils.writeInstant32(xmlNode, this.getTimestampAttribute());
                        break block0;
                    }
                    case TIMESTAMP_64: {
                        XmlUtils.writeInstant64(xmlNode, this.getTimestampAttribute());
                        break block0;
                    }
                    case DATE_TIME: {
                        XmlUtils.writeLocalDateTime(xmlNode, this.getDateTimeAttribute());
                        break block0;
                    }
                    case DATE: {
                        XmlUtils.writeLocalDate(xmlNode, this.getDateAttribute());
                        break block0;
                    }
                    case TIME: {
                        XmlUtils.writeLocalTime(xmlNode, this.getTimeAttribute());
                        break block0;
                    }
                    case GENERIC_MESSAGE: {
                        XmlUtils.writeGenericMessage(xmlNode, this.getGenericMessageAttribute(), fileDataWriter);
                    }
                }
            }
        }
    }

    @Override
    public AttributeDefinition getAttributeDefinition() {
        return this.attributeDefinition;
    }

    @Override
    public Message getReferencedObject() {
        if (this.value == null) {
            return null;
        }
        return (Message)this.value;
    }

    @Override
    public List<Message> getReferencedObjects() {
        if (this.value == null) {
            return null;
        }
        return (List)this.value;
    }

    @Override
    public <TYPE extends Message> TYPE getReferencedObjectAsType() {
        if (this.value == null) {
            return null;
        }
        return (TYPE)((Message)this.value);
    }

    @Override
    public <TYPE extends Message> List<TYPE> getReferencedObjectsAsType() {
        if (this.value == null) {
            return null;
        }
        return (List)this.value;
    }

    @Override
    public boolean getBooleanAttribute() {
        if (this.value == null) {
            return false;
        }
        return (Boolean)this.value;
    }

    @Override
    public byte getByteAttribute() {
        if (this.value == null) {
            return 0;
        }
        return (Byte)this.value;
    }

    @Override
    public int getIntAttribute() {
        if (this.value == null) {
            return 0;
        }
        return (Integer)this.value;
    }

    @Override
    public long getLongAttribute() {
        if (this.value == null) {
            return 0L;
        }
        return (Long)this.value;
    }

    @Override
    public float getFloatAttribute() {
        if (this.value == null) {
            return 0.0f;
        }
        return ((Float)this.value).floatValue();
    }

    @Override
    public double getDoubleAttribute() {
        if (this.value == null) {
            return 0.0;
        }
        return (Double)this.value;
    }

    @Override
    public String getStringAttribute() {
        if (this.value == null) {
            return null;
        }
        return (String)this.value;
    }

    @Override
    public FileData getFileData() {
        if (this.value == null) {
            return null;
        }
        return (FileData)this.value;
    }

    @Override
    public String getFileDataFileName() {
        if (this.value == null) {
            return null;
        }
        return this.getFileData().getFileName();
    }

    @Override
    public long getFileDataFileLength() {
        if (this.value == null) {
            return 0L;
        }
        return this.getFileData().getLength();
    }

    @Override
    public BitSet getBitSetAttribute() {
        if (this.value == null) {
            return null;
        }
        return (BitSet)this.value;
    }

    @Override
    public byte[] getByteArrayAttribute() {
        if (this.value == null) {
            return null;
        }
        return (byte[])this.value;
    }

    @Override
    public int[] getIntArrayAttribute() {
        if (this.value == null) {
            return null;
        }
        return (int[])this.value;
    }

    @Override
    public long[] getLongArrayAttribute() {
        if (this.value == null) {
            return null;
        }
        return (long[])this.value;
    }

    @Override
    public float[] getFloatArrayAttribute() {
        if (this.value == null) {
            return null;
        }
        return (float[])this.value;
    }

    @Override
    public double[] getDoubleArrayAttribute() {
        if (this.value == null) {
            return null;
        }
        return (double[])this.value;
    }

    @Override
    public String[] getStringArrayAttribute() {
        if (this.value == null) {
            return null;
        }
        return (String[])this.value;
    }

    @Override
    public Instant getTimestampAttribute() {
        if (this.value == null) {
            return null;
        }
        return (Instant)this.value;
    }

    @Override
    public LocalDateTime getDateTimeAttribute() {
        if (this.value == null) {
            return null;
        }
        return (LocalDateTime)this.value;
    }

    @Override
    public LocalDate getDateAttribute() {
        if (this.value == null) {
            return null;
        }
        return (LocalDate)this.value;
    }

    @Override
    public LocalTime getTimeAttribute() {
        if (this.value == null) {
            return null;
        }
        return (LocalTime)this.value;
    }

    @Override
    public Message getGenericMessageAttribute() {
        if (this.value == null) {
            return null;
        }
        return (Message)this.value;
    }

    @Override
    public String getAsString() {
        return String.valueOf(this.value);
    }

    @Override
    public String explain(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t".repeat(level)).append(this.attributeDefinition.getName()).append(", ");
        sb.append((Object)this.attributeDefinition.getType());
        if (this.attributeDefinition.isReferenceProperty()) {
            MessageModel referenceDefinition = this.attributeDefinition.getReferencedObject();
            if (this.attributeDefinition.isMultiReference()) {
                sb.append("\n");
                for (Message referencedObject : this.getReferencedObjects()) {
                    sb.append(referencedObject.explain(level + 1)).append("\n");
                }
            } else {
                sb.append("\n");
                Message referencedObject = this.getReferencedObject();
                sb.append(referencedObject.explain(level + 1));
            }
        } else if (this.attributeDefinition.isEnumProperty() && this.attributeDefinition.getEnumDefinition() != null) {
            int index = this.getIntAttribute();
            sb.append(": ").append(index > 0 ? this.attributeDefinition.getEnumDefinition().getEnumValues().get(index - 1) : "null");
        } else {
            sb.append(": ").append(this.value);
        }
        return sb.toString();
    }

    public String toString() {
        return this.explain(0);
    }
}

