/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.message.protocol.utils;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.teamapps.message.protocol.file.FileDataReader;
import org.teamapps.message.protocol.message.Message;
import org.teamapps.message.protocol.message.MessageModelCollection;
import org.teamapps.message.protocol.model.PojoObjectDecoder;

public class MessageReader
implements AutoCloseable {
    private final DataInputStream dis;
    private final FileDataReader fileDataReader;
    private MessageModelCollection messageModelCollection;

    public MessageReader(InputStream inputStream, FileDataReader fileDataReader, MessageModelCollection messageModelCollection) {
        this.dis = new DataInputStream(new BufferedInputStream(inputStream));
        this.fileDataReader = fileDataReader;
        this.messageModelCollection = messageModelCollection;
    }

    public Message readNextMessage() throws IOException {
        try {
            int length = this.dis.readInt();
            byte[] bytes = new byte[length];
            this.dis.readFully(bytes);
            String objectUuid = Message.readMessageUuid(bytes);
            PojoObjectDecoder<? extends Message> messageDecoder = this.messageModelCollection.getMessageDecoder(objectUuid);
            return messageDecoder.decode(bytes, this.fileDataReader);
        }
        catch (EOFException ignore) {
            return null;
        }
    }

    @Override
    public void close() throws Exception {
        this.dis.close();
    }
}

