/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.message.protocol.xml;

import org.teamapps.message.protocol.xml.XmlNode;

public class XmlBuilder {
    private final XmlNode rootNode;

    public XmlBuilder(XmlNode rootNode) {
        this.rootNode = rootNode;
    }

    public String getXml() {
        StringBuilder sb = new StringBuilder();
        this.printXml(0, this.rootNode, sb);
        return sb.toString();
    }

    private void printXml(int level, XmlNode node, StringBuilder sb) {
        if (node.isValue()) {
            this.printValue(level, node, sb);
        } else {
            this.printObject(level, node.getName(), false, sb);
            for (XmlNode child : node.getChildren()) {
                this.printXml(level + 1, child, sb);
            }
            this.printObject(level, node.getName(), true, sb);
        }
    }

    private void printTabs(int level, StringBuilder sb) {
        for (int i = 0; i < level; ++i) {
            sb.append("\t");
        }
    }

    private void printObject(int level, String name, boolean closeTag, StringBuilder sb) {
        this.printTabs(level, sb);
        this.printTag(name, closeTag, sb);
        sb.append("\n");
    }

    private void printValue(int level, XmlNode node, StringBuilder sb) {
        this.printTabs(level, sb);
        this.printTag(node.getName(), false, sb);
        sb.append(node.getValue());
        this.printTag(node.getName(), true, sb);
        sb.append("\n");
    }

    private void printTag(String name, boolean closeTag, StringBuilder sb) {
        sb.append("<");
        if (closeTag) {
            sb.append("/");
        }
        sb.append(name).append(">");
    }
}

