/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.api.generator;

import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="generate-message-model", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class MessageModelMojo
extends AbstractMojo {
    @Component
    private MavenProject mavenProject;
    @Component
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    @Parameter(defaultValue="${maven.version}", readonly=true)
    private String mavenVersion;
    @Parameter(defaultValue="${project.basedir}/src/main/model")
    private String modelSourceDirectory;
    @Parameter(defaultValue="MessageModel")
    private List<String> modelClasses;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/message-model-api")
    private String generatorTargetDirectory;

    public void execute() throws MojoExecutionException {
        this.checkMavenVersion();
        this.compileModel();
        this.mavenProject.addCompileSourceRoot(this.generatorTargetDirectory);
        this.executeModelGenerator();
        this.mavenProject.addCompileSourceRoot(this.modelSourceDirectory);
    }

    private void checkMavenVersion() throws MojoExecutionException {
        String[] parts = this.mavenVersion.split("\\.");
        int[] versionParts = new int[3];
        for (int i = 0; i < Math.min(parts.length, versionParts.length); ++i) {
            versionParts[i] = Integer.parseInt(parts[i]);
        }
        if (versionParts[0] * 1000000 + versionParts[1] * 1000 + versionParts[2] < 3003009) {
            String message = "Maven version needs to be at least 3.3.9 for teamapps-schema-generator-plugin to run! Your version is " + this.mavenVersion;
            this.getLog().error((CharSequence)message);
            throw new MojoExecutionException(message);
        }
    }

    private void compileModel() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Compiling model directory: " + this.modelSourceDirectory));
        MavenProject projectCopy = this.mavenProject.clone();
        List compileSourceRoots = projectCopy.getCompileSourceRoots();
        compileSourceRoots.clear();
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-compiler-plugin"), (String)MojoExecutor.version((String)"3.5.1")), (String)MojoExecutor.goal((String)"compile"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"compileSourceRoots"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"compileSourceRoot", (String)this.modelSourceDirectory)})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)projectCopy, (MavenSession)this.mavenSession.clone(), (BuildPluginManager)this.pluginManager));
    }

    private void executeModelGenerator() throws MojoExecutionException {
        if (this.modelClasses == null || this.modelClasses.isEmpty()) {
            this.getLog().error((CharSequence)"Please specify the model classes (configuration parameter: \"modelClasses\") to generate!");
        }
        for (String modelClassName : this.modelClasses) {
            this.getLog().info((CharSequence)("Generating model " + modelClassName + ". generatorTargetDirectory: " + this.generatorTargetDirectory));
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.codehaus.mojo"), (String)MojoExecutor.artifactId((String)"exec-maven-plugin"), (String)MojoExecutor.version((String)"1.3.2")), (String)MojoExecutor.goal((String)"java"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"mainClass"), (String)"org.teamapps.protocol.maven.ModelApiGenerator"), MojoExecutor.element((String)MojoExecutor.name((String)"commandlineArgs"), (String)(modelClassName + " \"" + this.generatorTargetDirectory + "\""))}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession.clone(), (BuildPluginManager)this.pluginManager));
        }
    }
}

