/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.protocol.message;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teamapps.protocol.message.MessageField;
import org.teamapps.protocol.message.MessageFieldContentType;
import org.teamapps.protocol.message.MessageFieldType;
import org.teamapps.protocol.message.MessageModel;
import org.teamapps.protocol.message.MessageUtils;
import org.teamapps.protocol.service.ServiceSchema;

public class MessageSchema
implements MessageModel {
    public static final int MAX_SCHEMA_ID = 2000000;
    private final int schemaId;
    private final String name;
    private final String namespace;
    private List<MessageField> topLevelFields = new ArrayList<MessageField>();
    private List<MessageField> fields = new ArrayList<MessageField>();
    private Map<Integer, MessageField> fieldMap = new HashMap<Integer, MessageField>();
    private Map<String, MessageField> fieldByPath = new HashMap<String, MessageField>();
    private List<ServiceSchema> serviceSchemas = new ArrayList<ServiceSchema>();

    public MessageSchema(int schemaId, String name, String namespace) {
        this.schemaId = schemaId;
        this.name = name;
        this.namespace = namespace;
        if (schemaId > 2000000) {
            throw new RuntimeException("Schema id is too high:" + schemaId + ", max schema id:2000000");
        }
    }

    public MessageSchema(DataInputStream dis) throws IOException {
        this.schemaId = dis.readInt();
        this.name = MessageUtils.readString(dis);
        this.namespace = MessageUtils.readString(dis);
        int fieldCount = dis.readInt();
        for (int i = 0; i < fieldCount; ++i) {
            this.fields.add(new MessageField(dis));
        }
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.schemaId);
        dos.writeInt(this.fields.size());
        MessageUtils.writeString(dos, this.namespace);
        for (MessageField field : this.fields) {
            field.write(dos);
        }
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.write(dos);
        dos.close();
        return bos.toByteArray();
    }

    public ServiceSchema addService(String serviceName) {
        return this.addService(new ServiceSchema(serviceName));
    }

    public ServiceSchema addService(ServiceSchema serviceSchema) {
        this.serviceSchemas.add(serviceSchema);
        return serviceSchema;
    }

    public MessageField addObject(String name) {
        return this.addObject(0, name, null);
    }

    public MessageField addSingleReference(MessageField field, MessageField reference, String name) {
        MessageField f = new MessageField(field.getId(), this.getNextFieldId(), name, null, MessageFieldType.OBJECT_SINGLE_REFERENCE, MessageFieldContentType.GENERIC, null, reference.getId());
        return this.addField(field, f);
    }

    public MessageField addSingleReference(MessageField field, MessageField reference, String name, String title) {
        MessageField f = new MessageField(field.getId(), this.getNextFieldId(), name, title, MessageFieldType.OBJECT_SINGLE_REFERENCE, MessageFieldContentType.GENERIC, null, reference.getId());
        return this.addField(field, f);
    }

    public MessageField addMultiReference(MessageField field, MessageField reference, String name) {
        MessageField f = new MessageField(field.getId(), this.getNextFieldId(), name, null, MessageFieldType.OBJECT_MULTI_REFERENCE, MessageFieldContentType.GENERIC, null, reference.getId());
        return this.addField(field, f);
    }

    public MessageField addMultiReference(MessageField field, MessageField reference, String name, String title) {
        MessageField f = new MessageField(field.getId(), this.getNextFieldId(), name, title, MessageFieldType.OBJECT_MULTI_REFERENCE, MessageFieldContentType.GENERIC, null, reference.getId());
        return this.addField(field, f);
    }

    public MessageField addFileField(MessageField parent, String name) {
        return this.addField(parent, name, MessageFieldType.FILE);
    }

    public MessageField addTextField(MessageField parent, String name) {
        return this.addField(parent, name, MessageFieldType.STRING);
    }

    public MessageField addIntField(MessageField parent, String name) {
        return this.addField(parent, name, MessageFieldType.INT);
    }

    public MessageField addLongField(MessageField parent, String name) {
        return this.addField(parent, name, MessageFieldType.LONG);
    }

    public MessageField addFloatField(MessageField parent, String name) {
        return this.addField(parent, name, MessageFieldType.FLOAT);
    }

    public MessageField addDoubleField(MessageField parent, String name) {
        return this.addField(parent, name, MessageFieldType.DOUBLE);
    }

    public MessageField addBooleanField(MessageField parent, String name) {
        return this.addField(parent, name, MessageFieldType.BOOLEAN);
    }

    public MessageField addByteField(MessageField parent, String name) {
        return this.addField(parent, name, MessageFieldType.BYTE);
    }

    public MessageField addBitsetField(MessageField parent, String name) {
        return this.addField(parent, name, MessageFieldType.BITSET);
    }

    public MessageField addByteArrayField(MessageField parent, String name) {
        return this.addField(parent, name, MessageFieldType.BYTE_ARRAY);
    }

    public MessageField addIntArrayField(MessageField parent, String name) {
        return this.addField(parent, name, MessageFieldType.INT_ARRAY);
    }

    public MessageField addLongArrayField(MessageField parent, String name) {
        return this.addField(parent, name, MessageFieldType.LONG_ARRAY);
    }

    public MessageField addFloatArrayField(MessageField parent, String name) {
        return this.addField(parent, name, MessageFieldType.FLOAT_ARRAY);
    }

    public MessageField addDoubleArrayField(MessageField parent, String name) {
        return this.addField(parent, name, MessageFieldType.DOUBLE_ARRAY);
    }

    public MessageField addStringArrayField(MessageField parent, String name) {
        return this.addField(parent, name, MessageFieldType.STRING_ARRAY);
    }

    public MessageField addObject(int localId, String name) {
        return this.addField(null, localId, name, null, MessageFieldType.OBJECT, MessageFieldContentType.GENERIC, null);
    }

    public MessageField addObject(int localId, String name, String title) {
        return this.addField(null, localId, name, title, MessageFieldType.OBJECT, MessageFieldContentType.GENERIC, null);
    }

    public MessageField addField(MessageField parent, String name, MessageFieldType type) {
        return this.addField(parent, 0, name, null, type);
    }

    public void addField(MessageField parent, String name, String title, MessageFieldType type) {
        this.addField(parent, 0, name, title, type);
    }

    public MessageField addField(MessageField parent, int localId, String name, String title, MessageFieldType type) {
        return this.addField(parent, localId, name, title, type, MessageFieldContentType.GENERIC, null);
    }

    protected MessageField addField(MessageField parent, String name, String title, MessageFieldType type, MessageFieldContentType contentType, String specificType) {
        return this.addField(parent, 0, name, title, type, contentType, specificType);
    }

    public MessageField addField(MessageField parent, int localId, String name, String title, MessageFieldType type, MessageFieldContentType contentType, String specificType) {
        int parentId = parent != null ? parent.getId() : 0;
        int id = localId > 0 ? localId + this.getSchemaIdPrefix() : this.getNextFieldId();
        MessageField field = new MessageField(parentId, id, name, title, type, contentType, specificType, 0);
        return this.addField(parent, field);
    }

    private MessageField addField(MessageField parent, MessageField field) {
        if (this.fieldMap.containsKey(field.getId())) {
            throw new RuntimeException("Message field with key already exists:" + field.getId());
        }
        if (parent == null) {
            this.topLevelFields.add(field);
        }
        if (parent != null) {
            parent.addField(field);
        }
        this.fields.add(field);
        this.fieldMap.put(field.getId(), field);
        this.fieldByPath.put(field.getPath(this), field);
        return field;
    }

    public int getSchemaIdPrefix() {
        return this.schemaId * 1000;
    }

    private int getNextFieldId() {
        return this.fields.size() + 1 + this.getSchemaIdPrefix();
    }

    public int getSchemaId() {
        return this.schemaId;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public List<MessageField> getAllFields() {
        return this.fields;
    }

    public MessageField getFieldByLocalId(int localId) {
        return this.fieldMap.get(this.getSchemaIdPrefix() + localId);
    }

    public List<MessageField> getTopLevelFields() {
        return this.topLevelFields;
    }

    public List<ServiceSchema> getServiceSchemas() {
        return this.serviceSchemas;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public MessageField getFieldById(int id) {
        return this.fieldMap.get(id);
    }

    @Override
    public MessageField getFieldByPath(String path) {
        return this.fieldByPath.get(path);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(", ").append(this.schemaId).append("\n");
        this.topLevelFields.forEach(field -> sb.append(field.explain(1)));
        return sb.toString();
    }
}

