/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.protocol.schema;

import org.teamapps.protocol.schema.EnumPropertyDefinition;
import org.teamapps.protocol.schema.ObjectPropertyDefinition;
import org.teamapps.protocol.schema.PropertyContentType;
import org.teamapps.protocol.schema.PropertyDefinition;
import org.teamapps.protocol.schema.PropertyType;
import org.teamapps.protocol.schema.ReferencePropertyDefinition;

public class AbstractPropertyDefinition
implements PropertyDefinition {
    private final ObjectPropertyDefinition parent;
    private final String name;
    private final int key;
    private final PropertyType type;
    private final PropertyContentType contentType;
    private final String specificType;
    private final String title;

    public AbstractPropertyDefinition(ObjectPropertyDefinition parent, String name, int key, PropertyType type, PropertyContentType contentType, String specificType, String title) {
        this.parent = parent;
        this.name = name;
        this.title = title;
        this.key = key;
        this.type = type;
        this.contentType = contentType;
        this.specificType = specificType;
    }

    @Override
    public ObjectPropertyDefinition getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public int getKey() {
        return this.key;
    }

    @Override
    public String getQualifiedName() {
        return this.parent.getQualifiedName() + "/" + this.name;
    }

    @Override
    public PropertyType getType() {
        return this.type;
    }

    @Override
    public PropertyContentType getContentType() {
        return this.contentType;
    }

    @Override
    public String getSpecificType() {
        return this.specificType;
    }

    @Override
    public boolean isReferenceProperty() {
        return this.type == PropertyType.OBJECT_SINGLE_REFERENCE || this.type == PropertyType.OBJECT_MULTI_REFERENCE;
    }

    @Override
    public boolean isEnumProperty() {
        return this.type == PropertyType.ENUM;
    }

    @Override
    public ReferencePropertyDefinition getAsReferencePropertyDefinition() {
        return null;
    }

    @Override
    public EnumPropertyDefinition getAsEnumPropertyDefinition() {
        return null;
    }

    @Override
    public byte[] toBytes() {
        return new byte[0];
    }
}

