/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.protocol.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teamapps.protocol.schema.AbstractPropertyDefinition;
import org.teamapps.protocol.schema.EnumPropertyDefinition;
import org.teamapps.protocol.schema.MessageModel;
import org.teamapps.protocol.schema.PropertyContentType;
import org.teamapps.protocol.schema.PropertyDefinition;
import org.teamapps.protocol.schema.PropertyType;
import org.teamapps.protocol.schema.ReferencePropertyDefinition;

public class ObjectPropertyDefinition
extends AbstractPropertyDefinition
implements MessageModel {
    private final String objectUuid;
    private final short modelVersion;
    private final List<PropertyDefinition> definitions = new ArrayList<PropertyDefinition>();
    private final Map<Integer, PropertyDefinition> definitionByKey = new HashMap<Integer, PropertyDefinition>();
    private final Map<String, PropertyDefinition> definitionByName = new HashMap<String, PropertyDefinition>();

    public ObjectPropertyDefinition(String objectUuid, String name, int modelVersion) {
        this(objectUuid, name, null, null, modelVersion);
    }

    public ObjectPropertyDefinition(String objectUuid, String name, String title, String specificType, int modelVersion) {
        super(null, name, 0, PropertyType.OBJECT, PropertyContentType.GENERIC, specificType, title);
        this.objectUuid = objectUuid;
        this.modelVersion = (short)modelVersion;
    }

    public String getObjectUuid() {
        return this.objectUuid;
    }

    public void addProperty(String name, int key, PropertyType type) {
        this.addProperty(name, key, type, PropertyContentType.GENERIC, null, null);
    }

    public void addProperty(String name, int key, PropertyType type, PropertyContentType contentType, String specificType, String title) {
        AbstractPropertyDefinition propertyDefinition = new AbstractPropertyDefinition(this, name, key, type, contentType, specificType, title);
        this.addProperty(propertyDefinition);
    }

    public void addSingleReference(String name, int key, ObjectPropertyDefinition referencedObject) {
        this.addSingleReference(name, key, null, null, referencedObject);
    }

    public void addSingleReference(String name, int key, String specificType, String title, ObjectPropertyDefinition referencedObject) {
        ReferencePropertyDefinition referencePropertyDefinition = new ReferencePropertyDefinition(this, name, key, specificType, title, referencedObject, false);
        this.addProperty(referencePropertyDefinition);
    }

    public void addMultiReference(String name, int key, ObjectPropertyDefinition referencedObject) {
        this.addMultiReference(name, key, null, null, referencedObject);
    }

    public void addMultiReference(String name, int key, String specificType, String title, ObjectPropertyDefinition referencedObject) {
        ReferencePropertyDefinition referencePropertyDefinition = new ReferencePropertyDefinition(this, name, key, specificType, title, referencedObject, true);
        this.addProperty(referencePropertyDefinition);
    }

    public void addEnumProperty(String name, int key, String[] enumValues, String specificType, String title) {
        EnumPropertyDefinition enumPropertyDefinition = new EnumPropertyDefinition(this, name, key, enumValues, specificType, title);
        this.addProperty(enumPropertyDefinition);
    }

    public void addProperty(PropertyDefinition field) {
        if (this.definitionByName.containsKey(field.getName()) || this.definitionByKey.containsKey(field.getKey())) {
            throw new RuntimeException("Object property already contains field with this name or key:" + field);
        }
        this.definitions.add(field);
        this.definitionByKey.put(field.getKey(), field);
        this.definitionByName.put(field.getName(), field);
    }

    @Override
    public ObjectPropertyDefinition getParent() {
        return null;
    }

    @Override
    public String getQualifiedName() {
        return this.getName() + "-" + this.objectUuid;
    }

    @Override
    public byte[] toBytes() {
        return new byte[0];
    }

    @Override
    public short getModelVersion() {
        return this.modelVersion;
    }

    @Override
    public ObjectPropertyDefinition getObjectPropertyDefinition() {
        return this;
    }

    @Override
    public List<PropertyDefinition> getPropertyDefinitions() {
        return this.definitions;
    }

    @Override
    public PropertyDefinition getPropertyDefinitionByKey(int key) {
        return this.definitionByKey.get(key);
    }

    @Override
    public PropertyDefinition getPropertyDefinitionByName(String name) {
        return this.definitionByName.get(name);
    }
}

