/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.protocol.schema;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.teamapps.protocol.message.MessageUtils;
import org.teamapps.protocol.schema.MessageModel;
import org.teamapps.protocol.schema.ObjectPropertyDefinition;
import org.teamapps.protocol.schema.PropertyContentType;
import org.teamapps.protocol.schema.PropertyDefinition;
import org.teamapps.protocol.schema.PropertyType;

public class AbstractPropertyDefinition
implements PropertyDefinition {
    private final ObjectPropertyDefinition parent;
    private final String name;
    private final int key;
    private final PropertyType type;
    private final PropertyContentType contentType;
    private final String specificType;
    private final String title;
    private final ObjectPropertyDefinition referencedObject;
    private final boolean multiReference;

    public AbstractPropertyDefinition(ObjectPropertyDefinition parent, String name, int key, PropertyType type, PropertyContentType contentType, String specificType, String title) {
        this.parent = parent;
        this.name = name;
        this.title = title;
        this.key = key;
        this.type = type;
        this.contentType = contentType;
        this.specificType = specificType;
        this.referencedObject = null;
        this.multiReference = false;
    }

    public AbstractPropertyDefinition(ObjectPropertyDefinition parent, String name, int key, String specificType, String title, ObjectPropertyDefinition referencedObject, boolean multiReference) {
        this.parent = parent;
        this.name = name;
        this.title = title;
        this.key = key;
        this.type = multiReference ? PropertyType.OBJECT_MULTI_REFERENCE : PropertyType.OBJECT_SINGLE_REFERENCE;
        this.contentType = PropertyContentType.GENERIC;
        this.specificType = specificType;
        this.referencedObject = referencedObject;
        this.multiReference = multiReference;
    }

    public AbstractPropertyDefinition(ObjectPropertyDefinition parent, byte[] bytes, Map<String, MessageModel> readCache) throws IOException {
        this(parent, new DataInputStream(new ByteArrayInputStream(bytes)), readCache);
    }

    public AbstractPropertyDefinition(ObjectPropertyDefinition parent, DataInputStream dis, Map<String, MessageModel> readCache) throws IOException {
        this.parent = parent;
        this.name = MessageUtils.readString(dis);
        this.key = dis.readInt();
        this.type = PropertyType.getById(dis.readInt());
        this.contentType = PropertyContentType.getById(dis.readInt());
        this.specificType = MessageUtils.readString(dis);
        this.title = MessageUtils.readString(dis);
        if (this.type == PropertyType.OBJECT_SINGLE_REFERENCE || this.type == PropertyType.OBJECT_MULTI_REFERENCE) {
            this.multiReference = dis.readBoolean();
            if (dis.readBoolean()) {
                String objectUuid = MessageUtils.readString(dis);
                this.referencedObject = readCache.get(objectUuid).getObjectPropertyDefinition();
            } else {
                this.referencedObject = new ObjectPropertyDefinition(dis, readCache);
            }
        } else {
            this.referencedObject = null;
            this.multiReference = false;
        }
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        this.write(dos, new HashMap<String, MessageModel>());
    }

    @Override
    public void write(DataOutputStream dos, Map<String, MessageModel> writeCache) throws IOException {
        MessageUtils.writeString(dos, this.name);
        dos.writeInt(this.key);
        dos.writeInt(this.type.getId());
        dos.writeInt(this.contentType.getId());
        MessageUtils.writeString(dos, this.specificType);
        MessageUtils.writeString(dos, this.title);
        if (this.isReferenceProperty()) {
            dos.writeBoolean(this.multiReference);
            if (writeCache.containsKey(this.referencedObject.getObjectUuid())) {
                dos.writeBoolean(true);
                MessageUtils.writeString(dos, this.referencedObject.getObjectUuid());
            } else {
                writeCache.put(this.referencedObject.getObjectUuid(), this.referencedObject);
                dos.writeBoolean(false);
                this.referencedObject.write(dos, writeCache);
            }
        }
    }

    @Override
    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.write(dos);
        dos.close();
        return bos.toByteArray();
    }

    @Override
    public ObjectPropertyDefinition getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public int getKey() {
        return this.key;
    }

    @Override
    public String getQualifiedName() {
        return this.parent.getQualifiedName() + "/" + this.name;
    }

    @Override
    public PropertyType getType() {
        return this.type;
    }

    @Override
    public PropertyContentType getContentType() {
        return this.contentType;
    }

    @Override
    public String getSpecificType() {
        return this.specificType;
    }

    @Override
    public boolean isReferenceProperty() {
        return this.type == PropertyType.OBJECT_SINGLE_REFERENCE || this.type == PropertyType.OBJECT_MULTI_REFERENCE;
    }

    @Override
    public boolean isEnumProperty() {
        return this.type == PropertyType.ENUM;
    }

    @Override
    public ObjectPropertyDefinition getReferencedObject() {
        return this.referencedObject;
    }

    @Override
    public boolean isMultiReference() {
        return this.multiReference;
    }
}

