/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.protocol.schema;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teamapps.protocol.file.FileProvider;
import org.teamapps.protocol.file.FileSink;
import org.teamapps.protocol.message.MessageUtils;
import org.teamapps.protocol.schema.AbstractMessageProperty;
import org.teamapps.protocol.schema.FileProperty;
import org.teamapps.protocol.schema.MessageModel;
import org.teamapps.protocol.schema.MessageProperty;
import org.teamapps.protocol.schema.ModelRegistry;
import org.teamapps.protocol.schema.ObjectPropertyDefinition;
import org.teamapps.protocol.schema.PojoObjectDecoderRegistry;
import org.teamapps.protocol.schema.PropertyContentType;
import org.teamapps.protocol.schema.PropertyDefinition;
import org.teamapps.protocol.schema.PropertyType;

public class MessageObject {
    private final ObjectPropertyDefinition objectPropertyDefinition;
    private final List<MessageProperty> properties;
    private final Map<String, MessageProperty> propertyByName;

    public static String readMessageObjectUuid(byte[] bytes) throws IOException {
        return MessageUtils.readString(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public static String readMessageObjectUuid(ByteBuf buf) {
        return MessageUtils.readString(buf);
    }

    public MessageObject(ObjectPropertyDefinition objectPropertyDefinition) {
        this.objectPropertyDefinition = objectPropertyDefinition;
        this.properties = new ArrayList<MessageProperty>();
        this.propertyByName = new HashMap<String, MessageProperty>();
    }

    public MessageObject(MessageModel model) {
        this(model.getObjectPropertyDefinition());
    }

    public MessageObject(MessageObject message, PojoObjectDecoderRegistry decoderRegistry) {
        this.objectPropertyDefinition = message.objectPropertyDefinition;
        this.properties = new ArrayList<MessageProperty>();
        this.propertyByName = new HashMap<String, MessageProperty>();
        for (MessageProperty property : message.getProperties()) {
            AbstractMessageProperty messageProperty = new AbstractMessageProperty((AbstractMessageProperty)property, decoderRegistry);
            this.properties.add(messageProperty);
            this.propertyByName.put(property.getPropertyDefinition().getName(), messageProperty);
        }
    }

    public MessageObject(byte[] bytes, MessageModel model, FileProvider fileProvider, PojoObjectDecoderRegistry decoderRegistry) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(bytes)), model, fileProvider, decoderRegistry);
    }

    public MessageObject(byte[] bytes, ModelRegistry modelRegistry, FileProvider fileProvider, PojoObjectDecoderRegistry decoderRegistry) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(bytes)), modelRegistry, fileProvider, decoderRegistry);
    }

    public MessageObject(DataInputStream dis, ModelRegistry modelRegistry, FileProvider fileProvider, PojoObjectDecoderRegistry decoderRegistry) throws IOException {
        String objectUuid = MessageUtils.readString(dis);
        short modelVersion = dis.readShort();
        MessageModel model = modelRegistry.getModel(objectUuid, modelVersion);
        this.objectPropertyDefinition = model.getObjectPropertyDefinition();
        this.properties = new ArrayList<MessageProperty>();
        this.propertyByName = new HashMap<String, MessageProperty>();
        int propertyCount = dis.readShort();
        for (int i = 0; i < propertyCount; ++i) {
            AbstractMessageProperty messageProperty = new AbstractMessageProperty(dis, (MessageModel)this.objectPropertyDefinition, fileProvider, decoderRegistry);
            this.properties.add(messageProperty);
            this.propertyByName.put(messageProperty.getPropertyDefinition().getName(), messageProperty);
        }
    }

    public MessageObject(ByteBuf buf, ModelRegistry modelRegistry, FileProvider fileProvider, PojoObjectDecoderRegistry decoderRegistry) throws IOException {
        String objectUuid = MessageUtils.readString(buf);
        short modelVersion = buf.readShort();
        MessageModel model = modelRegistry.getModel(objectUuid, modelVersion);
        this.objectPropertyDefinition = model.getObjectPropertyDefinition();
        this.properties = new ArrayList<MessageProperty>();
        this.propertyByName = new HashMap<String, MessageProperty>();
        int propertyCount = buf.readShort();
        for (int i = 0; i < propertyCount; ++i) {
            AbstractMessageProperty messageProperty = new AbstractMessageProperty(buf, (MessageModel)this.objectPropertyDefinition, fileProvider, decoderRegistry);
            this.properties.add(messageProperty);
            this.propertyByName.put(messageProperty.getPropertyDefinition().getName(), messageProperty);
        }
    }

    public MessageObject(DataInputStream dis, MessageModel model, FileProvider fileProvider, PojoObjectDecoderRegistry decoderRegistry) throws IOException {
        this.objectPropertyDefinition = model.getObjectPropertyDefinition();
        this.properties = new ArrayList<MessageProperty>();
        this.propertyByName = new HashMap<String, MessageProperty>();
        String objectUuid = MessageUtils.readString(dis);
        if (!model.getObjectPropertyDefinition().getObjectUuid().equals(objectUuid)) {
            throw new RuntimeException("Cannot parse message with wrong model:" + objectUuid + ", expected:" + this.objectPropertyDefinition.getObjectUuid());
        }
        short modelVersion = dis.readShort();
        if (model.getModelVersion() != modelVersion) {
            System.out.println("Wrong model version " + model + ", expected: " + model.getModelVersion());
        }
        int propertyCount = dis.readShort();
        for (int i = 0; i < propertyCount; ++i) {
            AbstractMessageProperty messageProperty = new AbstractMessageProperty(dis, (MessageModel)this.objectPropertyDefinition, fileProvider, decoderRegistry);
            this.properties.add(messageProperty);
            this.propertyByName.put(messageProperty.getPropertyDefinition().getName(), messageProperty);
        }
    }

    public MessageObject(ByteBuf buf, MessageModel model, FileProvider fileProvider, PojoObjectDecoderRegistry decoderRegistry) throws IOException {
        this.objectPropertyDefinition = model.getObjectPropertyDefinition();
        this.properties = new ArrayList<MessageProperty>();
        this.propertyByName = new HashMap<String, MessageProperty>();
        String objectUuid = MessageUtils.readString(buf);
        if (!model.getObjectPropertyDefinition().getObjectUuid().equals(objectUuid)) {
            throw new RuntimeException("Cannot parse message with wrong model:" + objectUuid + ", expected:" + this.objectPropertyDefinition.getObjectUuid());
        }
        short modelVersion = buf.readShort();
        if (model.getModelVersion() != modelVersion) {
            System.out.println("Wrong model version " + model + ", expected: " + model.getModelVersion());
        }
        int propertyCount = buf.readShort();
        for (int i = 0; i < propertyCount; ++i) {
            AbstractMessageProperty messageProperty = new AbstractMessageProperty(buf, (MessageModel)this.objectPropertyDefinition, fileProvider, decoderRegistry);
            this.properties.add(messageProperty);
            this.propertyByName.put(messageProperty.getPropertyDefinition().getName(), messageProperty);
        }
    }

    public MessageModel getModel() {
        return this.objectPropertyDefinition;
    }

    public String getName() {
        return this.objectPropertyDefinition.getName();
    }

    public List<MessageProperty> getProperties() {
        return this.properties;
    }

    public void write(DataOutputStream dos, FileSink fileSink) throws IOException {
        MessageUtils.writeString(dos, this.objectPropertyDefinition.getObjectUuid());
        dos.writeShort(this.objectPropertyDefinition.getModelVersion());
        dos.writeShort(this.properties.size());
        for (MessageProperty field : this.properties) {
            field.write(dos, fileSink);
        }
    }

    public void write(ByteBuf buffer, FileSink fileSink) throws IOException {
        MessageUtils.writeString(buffer, this.objectPropertyDefinition.getObjectUuid());
        buffer.writeShort((int)this.objectPropertyDefinition.getModelVersion());
        buffer.writeShort(this.properties.size());
        for (MessageProperty field : this.properties) {
            field.write(buffer, fileSink);
        }
    }

    public byte[] toBytes() throws IOException {
        return this.toBytes(null);
    }

    public byte[] toBytes(FileSink fileSink) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.write(dos, fileSink);
        dos.close();
        return bos.toByteArray();
    }

    public MessageObject setReferencedObject(String name, MessageObject value) {
        this.setProperty(name, value);
        return this;
    }

    public MessageObject setReferencedObjects(String name, List<MessageObject> value) {
        this.setProperty(name, value);
        return this;
    }

    public <TYPE extends MessageObject> MessageObject setReferencedObjectAsType(String name, TYPE value) {
        this.setProperty(name, value);
        return this;
    }

    public <TYPE extends MessageObject> MessageObject setReferencedObjectsAsType(String name, List<TYPE> value) {
        this.setProperty(name, value);
        return this;
    }

    public MessageObject setBooleanProperty(String name, boolean value) {
        this.setProperty(name, value);
        return this;
    }

    public MessageObject setByteProperty(String name, byte value) {
        this.setProperty(name, value);
        return this;
    }

    public MessageObject setIntProperty(String name, int value) {
        this.setProperty(name, value);
        return this;
    }

    public MessageObject setLongProperty(String name, long value) {
        this.setProperty(name, value);
        return this;
    }

    public MessageObject setFloatProperty(String name, float value) {
        this.setProperty(name, Float.valueOf(value));
        return this;
    }

    public MessageObject setDoubleProperty(String name, double value) {
        this.setProperty(name, value);
        return this;
    }

    public MessageObject setStringProperty(String name, String value) {
        this.setProperty(name, value);
        return this;
    }

    public MessageObject setFileProperty(String name, FileProperty value) {
        this.setProperty(name, value);
        return this;
    }

    public MessageObject setFileProperty(String name, File file) {
        this.setProperty(name, file != null ? new FileProperty(file) : null);
        return this;
    }

    public MessageObject setFileProperty(String name, File file, String fileName) {
        this.setProperty(name, file != null ? new FileProperty(fileName, file) : null);
        return this;
    }

    public MessageObject setBitSetProperty(String name, BitSet value) {
        this.setProperty(name, value);
        return this;
    }

    public MessageObject setByteArrayProperty(String name, byte[] value) {
        this.setProperty(name, value);
        return this;
    }

    public MessageObject setIntArrayProperty(String name, int[] value) {
        this.setProperty(name, value);
        return this;
    }

    public MessageObject setLongArrayProperty(String name, long[] value) {
        this.setProperty(name, value);
        return this;
    }

    public MessageObject setFloatArrayProperty(String name, float[] value) {
        this.setProperty(name, value);
        return this;
    }

    public MessageObject setDoubleArrayProperty(String name, double[] value) {
        this.setProperty(name, value);
        return this;
    }

    public MessageObject setStringArrayProperty(String name, String[] value) {
        this.setProperty(name, value);
        return this;
    }

    public MessageObject getReferencedObject(String propertyName) {
        MessageProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getReferencedObject();
        }
        return null;
    }

    public List<MessageObject> getReferencedObjects(String propertyName) {
        MessageProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getReferencedObjects();
        }
        return null;
    }

    public <TYPE extends MessageObject> TYPE getReferencedObjectAsType(String propertyName) {
        MessageProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getReferencedObjectAsType();
        }
        return null;
    }

    public <TYPE extends MessageObject> List<TYPE> getReferencedObjectsAsType(String propertyName) {
        MessageProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getReferencedObjectsAsType();
        }
        return null;
    }

    public boolean getBooleanProperty(String propertyName) {
        MessageProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getBooleanProperty();
        }
        return false;
    }

    public byte getByteProperty(String propertyName) {
        MessageProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getByteProperty();
        }
        return 0;
    }

    public int getIntProperty(String propertyName) {
        MessageProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getIntProperty();
        }
        return 0;
    }

    public long getLongProperty(String propertyName) {
        MessageProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getLongProperty();
        }
        return 0L;
    }

    public float getFloatProperty(String propertyName) {
        MessageProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getFloatProperty();
        }
        return 0.0f;
    }

    public double getDoubleProperty(String propertyName) {
        MessageProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getDoubleProperty();
        }
        return 0.0;
    }

    public String getStringProperty(String propertyName) {
        MessageProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getStringProperty();
        }
        return null;
    }

    public FileProperty getFileProperty(String propertyName) {
        MessageProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getFileProperty();
        }
        return null;
    }

    public File getFilePropertyAsFile(String propertyName) {
        MessageProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getFilePropertyAsFile();
        }
        return null;
    }

    public String getFilePropertyAsFileName(String propertyName) {
        MessageProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getFilePropertyAsFileName();
        }
        return null;
    }

    public long getFilePropertyAsFileLength(String propertyName) {
        MessageProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getFilePropertyAsFileLength();
        }
        return 0L;
    }

    public BitSet getBitSetProperty(String propertyName) {
        MessageProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getBitSetProperty();
        }
        return null;
    }

    public byte[] getByteArrayProperty(String propertyName) {
        MessageProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getByteArrayProperty();
        }
        return null;
    }

    public int[] getIntArrayProperty(String propertyName) {
        MessageProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getIntArrayProperty();
        }
        return null;
    }

    public long[] getLongArrayProperty(String propertyName) {
        MessageProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getLongArrayProperty();
        }
        return null;
    }

    public float[] getFloatArrayProperty(String propertyName) {
        MessageProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getFloatArrayProperty();
        }
        return null;
    }

    public double[] getDoubleArrayProperty(String propertyName) {
        MessageProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getDoubleArrayProperty();
        }
        return null;
    }

    public String[] getStringArrayProperty(String propertyName) {
        MessageProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getStringArrayProperty();
        }
        return null;
    }

    public void addReference(String name, MessageObject messageObject) {
        PropertyDefinition propertyDefinition = this.objectPropertyDefinition.getPropertyDefinitionByName(name);
        if (propertyDefinition == null) {
            throw new RuntimeException("Message model does not contain a field with name:" + name);
        }
        if (propertyDefinition.getType() == PropertyType.OBJECT_SINGLE_REFERENCE) {
            this.setProperty(name, messageObject);
        } else if (propertyDefinition.getType() == PropertyType.OBJECT_MULTI_REFERENCE) {
            MessageProperty messageProperty = this.getProperty(name);
            if (messageProperty == null) {
                ArrayList<MessageObject> messageObjects = new ArrayList<MessageObject>();
                messageObjects.add(messageObject);
                this.setProperty(name, messageObjects);
            } else {
                List<MessageObject> referencedObjects = messageProperty.getReferencedObjects();
                referencedObjects.add(messageObject);
            }
        }
    }

    public void setProperty(String name, Object value) {
        PropertyDefinition propertyDefinition = this.objectPropertyDefinition.getPropertyDefinitionByName(name);
        if (propertyDefinition == null) {
            throw new RuntimeException("Message model does not contain a field with name:" + name);
        }
        MessageProperty existingField = this.propertyByName.get(name);
        if (existingField != null) {
            this.properties.remove(existingField);
            if (value != null) {
                AbstractMessageProperty messageProperty = new AbstractMessageProperty(propertyDefinition, value);
                this.properties.add(messageProperty);
                this.propertyByName.put(name, messageProperty);
            } else {
                this.propertyByName.remove(name);
            }
        } else if (value != null) {
            AbstractMessageProperty messageProperty = new AbstractMessageProperty(propertyDefinition, value);
            this.properties.add(messageProperty);
            this.propertyByName.put(name, messageProperty);
        }
    }

    public void removeField(PropertyDefinition propertyDefinition) {
        MessageProperty existingField = this.propertyByName.get(propertyDefinition);
        if (existingField != null) {
            this.properties.remove(existingField);
            this.propertyByName.remove(propertyDefinition);
        }
    }

    public MessageProperty getProperty(String name) {
        return this.propertyByName.get(name);
    }

    protected String explain(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t".repeat(level)).append(this.objectPropertyDefinition.getName()).append(", ");
        if (this.objectPropertyDefinition.getTitle() != null) {
            sb.append(this.objectPropertyDefinition.getTitle()).append(", ");
        }
        sb.append("[").append(this.objectPropertyDefinition.getObjectUuid()).append("], ").append((Object)this.objectPropertyDefinition.getType());
        sb.append((String)(this.objectPropertyDefinition.getContentType() != PropertyContentType.GENERIC ? ", " + this.objectPropertyDefinition.getContentType() : ""));
        for (MessageProperty property : this.properties) {
            sb.append("\n");
            sb.append(property.explain(level + 1));
        }
        return sb.toString();
    }

    public String toString() {
        return this.explain(0);
    }
}

