/*-
 * ========================LICENSE_START=================================
 * TeamApps Protocol Schema
 * ---
 * Copyright (C) 2022 TeamApps.org
 * ---
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
package org.teamapps.protocol.schema;

import org.teamapps.protocol.file.FileProvider;

import java.io.*;

public class MessageReader implements AutoCloseable {

	private final DataInputStream dis;
	private final FileProvider fileProvider;
	private MessageModelCollection messageModelCollection;

	public MessageReader(InputStream inputStream, FileProvider fileProvider, MessageModelCollection messageModelCollection) {
		this.dis = new DataInputStream(new BufferedInputStream(inputStream));
		this.fileProvider = fileProvider;
		this.messageModelCollection = messageModelCollection;
	}

	public MessageObject readNextMessage() throws IOException {
		try {
			int length = dis.readInt();
			byte[] bytes = new byte[length];
			dis.readFully(bytes);
			String objectUuid = MessageObject.readMessageObjectUuid(bytes);
			PojoObjectDecoder<? extends MessageObject> messageDecoder = messageModelCollection.getMessageDecoder(objectUuid);
			return messageDecoder.decode(bytes, fileProvider);
		} catch (EOFException ignore) {
			return null;
		}
	}

	@Override
	public void close() throws Exception {
		dis.close();
	}
}
