/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.protocol.schema;

import org.teamapps.protocol.schema.ClusterServiceRegistry;
import org.teamapps.protocol.schema.MessageObject;
import org.teamapps.protocol.schema.PojoObjectDecoder;

public abstract class AbstractClusterServiceClient {
    private final ClusterServiceRegistry clusterServiceRegistry;
    private final String serviceName;

    public AbstractClusterServiceClient(ClusterServiceRegistry clusterServiceRegistry, String serviceName) {
        this.clusterServiceRegistry = clusterServiceRegistry;
        this.serviceName = serviceName;
    }

    protected <REQUEST extends MessageObject, RESPONSE extends MessageObject> RESPONSE executeClusterServiceMethod(String method, REQUEST request, PojoObjectDecoder<RESPONSE> responseDecoder) {
        return this.clusterServiceRegistry.executeServiceMethod(this.serviceName, method, request, responseDecoder);
    }

    public boolean isAvailable() {
        return this.clusterServiceRegistry.isServiceAvailable(this.serviceName);
    }
}

