/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.protocol.schema;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.teamapps.protocol.file.FileProvider;
import org.teamapps.protocol.file.FileSink;
import org.teamapps.protocol.message.MessageUtils;
import org.teamapps.protocol.schema.FileProperty;
import org.teamapps.protocol.schema.MessageModel;
import org.teamapps.protocol.schema.MessageObject;
import org.teamapps.protocol.schema.MessageProperty;
import org.teamapps.protocol.schema.ObjectPropertyDefinition;
import org.teamapps.protocol.schema.PojoObjectDecoder;
import org.teamapps.protocol.schema.PojoObjectDecoderRegistry;
import org.teamapps.protocol.schema.PropertyContentType;
import org.teamapps.protocol.schema.PropertyDefinition;
import org.teamapps.protocol.schema.PropertyType;

public class AbstractMessageProperty
implements MessageProperty {
    private final PropertyDefinition propertyDefinition;
    private final Object value;

    public AbstractMessageProperty(PropertyDefinition propertyDefinition, Object value) {
        this.propertyDefinition = propertyDefinition;
        this.value = value;
    }

    public AbstractMessageProperty(AbstractMessageProperty property, PojoObjectDecoderRegistry decoderRegistry) {
        this.propertyDefinition = property.propertyDefinition;
        if (this.propertyDefinition.isReferenceProperty()) {
            ObjectPropertyDefinition referencedObjectDefinition = this.propertyDefinition.getReferencedObject();
            PojoObjectDecoder<? extends MessageObject> messageDecoder = decoderRegistry.getMessageDecoder(referencedObjectDefinition.getObjectUuid());
            if (this.propertyDefinition.isMultiReference()) {
                List messageObjects = (List)property.value;
                ArrayList<MessageObject> remappedMessages = new ArrayList<MessageObject>();
                for (MessageObject messageObject : messageObjects) {
                    remappedMessages.add(messageDecoder.remap(messageObject));
                }
                this.value = remappedMessages;
            } else {
                MessageObject messageObject = (MessageObject)property.value;
                this.value = messageDecoder.remap(messageObject);
            }
        } else {
            this.value = property.value;
        }
    }

    public AbstractMessageProperty(DataInputStream dis, MessageModel model, FileProvider fileProvider, PojoObjectDecoderRegistry decoderRegistry) throws IOException {
        PropertyType type = PropertyType.getById(dis.readByte());
        short key = dis.readShort();
        this.propertyDefinition = model.getPropertyDefinitionByKey(key);
        if (type != this.propertyDefinition.getType()) {
            throw new RuntimeException("Message parsing error - property type mismatch: " + type + " <-> " + this.propertyDefinition.getType());
        }
        switch (this.propertyDefinition.getType()) {
            case OBJECT_SINGLE_REFERENCE: {
                ObjectPropertyDefinition referencedObjectDefinition = this.propertyDefinition.getReferencedObject();
                if (decoderRegistry != null && decoderRegistry.containsDecoder(referencedObjectDefinition.getObjectUuid())) {
                    PojoObjectDecoder<? extends MessageObject> messageDecoder = decoderRegistry.getMessageDecoder(referencedObjectDefinition.getObjectUuid());
                    this.value = messageDecoder.decode(dis, fileProvider);
                    break;
                }
                this.value = new MessageObject(dis, (MessageModel)referencedObjectDefinition, fileProvider, decoderRegistry);
                break;
            }
            case OBJECT_MULTI_REFERENCE: {
                ObjectPropertyDefinition referencedObjectDefinition = this.propertyDefinition.getReferencedObject();
                ArrayList<MessageObject> messageObjects = new ArrayList<MessageObject>();
                int messageCount = dis.readInt();
                if (decoderRegistry != null && decoderRegistry.containsDecoder(referencedObjectDefinition.getObjectUuid())) {
                    PojoObjectDecoder<? extends MessageObject> messageDecoder = decoderRegistry.getMessageDecoder(referencedObjectDefinition.getObjectUuid());
                    for (int i = 0; i < messageCount; ++i) {
                        messageObjects.add(messageDecoder.decode(dis, fileProvider));
                    }
                } else {
                    for (int i = 0; i < messageCount; ++i) {
                        messageObjects.add(new MessageObject(dis, (MessageModel)referencedObjectDefinition, fileProvider, decoderRegistry));
                    }
                }
                this.value = messageObjects;
                break;
            }
            case BOOLEAN: {
                this.value = dis.readBoolean();
                break;
            }
            case BYTE: {
                this.value = dis.readByte();
                break;
            }
            case INT: {
                this.value = dis.readInt();
                break;
            }
            case LONG: {
                this.value = dis.readLong();
                break;
            }
            case FLOAT: {
                this.value = Float.valueOf(dis.readFloat());
                break;
            }
            case DOUBLE: {
                this.value = dis.readDouble();
                break;
            }
            case STRING: {
                this.value = MessageUtils.readString(dis);
                break;
            }
            case BITSET: {
                this.value = MessageUtils.readBitSet(dis);
                break;
            }
            case BYTE_ARRAY: {
                this.value = MessageUtils.readByteArray(dis);
                break;
            }
            case INT_ARRAY: {
                this.value = MessageUtils.readIntArray(dis);
                break;
            }
            case LONG_ARRAY: {
                this.value = MessageUtils.readLongArray(dis);
                break;
            }
            case FLOAT_ARRAY: {
                this.value = MessageUtils.readFloatArray(dis);
                break;
            }
            case DOUBLE_ARRAY: {
                this.value = MessageUtils.readDoubleArray(dis);
                break;
            }
            case STRING_ARRAY: {
                this.value = MessageUtils.readStringArray(dis);
                break;
            }
            case FILE: {
                this.value = MessageUtils.readFileProperty(dis, fileProvider);
                break;
            }
            case ENUM: {
                this.value = null;
                break;
            }
            default: {
                throw new RuntimeException("Message parsing error - property type unknown:" + this.propertyDefinition.getType());
            }
        }
    }

    public AbstractMessageProperty(ByteBuf buf, MessageModel model, FileProvider fileProvider, PojoObjectDecoderRegistry decoderRegistry) throws IOException {
        PropertyType type = PropertyType.getById(buf.readByte());
        short key = buf.readShort();
        this.propertyDefinition = model.getPropertyDefinitionByKey(key);
        if (type != this.propertyDefinition.getType()) {
            throw new RuntimeException("Message parsing error - property type mismatch: " + type + " <-> " + this.propertyDefinition.getType());
        }
        switch (this.propertyDefinition.getType()) {
            case OBJECT_SINGLE_REFERENCE: {
                ObjectPropertyDefinition referencedObjectDefinition = this.propertyDefinition.getReferencedObject();
                if (decoderRegistry != null && decoderRegistry.containsDecoder(referencedObjectDefinition.getObjectUuid())) {
                    PojoObjectDecoder<? extends MessageObject> messageDecoder = decoderRegistry.getMessageDecoder(referencedObjectDefinition.getObjectUuid());
                    this.value = messageDecoder.decode(buf, fileProvider);
                    break;
                }
                this.value = new MessageObject(buf, (MessageModel)referencedObjectDefinition, fileProvider, decoderRegistry);
                break;
            }
            case OBJECT_MULTI_REFERENCE: {
                ObjectPropertyDefinition referencedObjectDefinition = this.propertyDefinition.getReferencedObject();
                ArrayList<MessageObject> messageObjects = new ArrayList<MessageObject>();
                int messageCount = buf.readInt();
                if (decoderRegistry != null && decoderRegistry.containsDecoder(referencedObjectDefinition.getObjectUuid())) {
                    PojoObjectDecoder<? extends MessageObject> messageDecoder = decoderRegistry.getMessageDecoder(referencedObjectDefinition.getObjectUuid());
                    for (int i = 0; i < messageCount; ++i) {
                        messageObjects.add(messageDecoder.decode(buf, fileProvider));
                    }
                } else {
                    for (int i = 0; i < messageCount; ++i) {
                        messageObjects.add(new MessageObject(buf, (MessageModel)referencedObjectDefinition, fileProvider, decoderRegistry));
                    }
                }
                this.value = messageObjects;
                break;
            }
            case BOOLEAN: {
                this.value = buf.readBoolean();
                break;
            }
            case BYTE: {
                this.value = buf.readByte();
                break;
            }
            case INT: {
                this.value = buf.readInt();
                break;
            }
            case LONG: {
                this.value = buf.readLong();
                break;
            }
            case FLOAT: {
                this.value = Float.valueOf(buf.readFloat());
                break;
            }
            case DOUBLE: {
                this.value = buf.readDouble();
                break;
            }
            case STRING: {
                this.value = MessageUtils.readString(buf);
                break;
            }
            case BYTE_ARRAY: {
                this.value = MessageUtils.readByteArray(buf);
                break;
            }
            case ENUM: {
                this.value = null;
                break;
            }
            default: {
                throw new RuntimeException("Message parsing error - property type unknown:" + this.propertyDefinition.getType());
            }
        }
    }

    @Override
    public void write(DataOutputStream dos, FileSink fileSink) throws IOException {
        dos.writeByte(this.propertyDefinition.getType().getId());
        dos.writeShort(this.propertyDefinition.getKey());
        switch (this.propertyDefinition.getType()) {
            case OBJECT_SINGLE_REFERENCE: {
                MessageObject referencedObject = this.getReferencedObject();
                referencedObject.write(dos, fileSink);
                break;
            }
            case OBJECT_MULTI_REFERENCE: {
                List<MessageObject> referencedObjects = this.getReferencedObjects();
                if (referencedObjects == null || referencedObjects.isEmpty()) {
                    dos.writeInt(0);
                    break;
                }
                dos.writeInt(referencedObjects.size());
                for (MessageObject referencedObject : referencedObjects) {
                    referencedObject.write(dos, fileSink);
                }
                break;
            }
            case BOOLEAN: {
                dos.writeBoolean(this.getBooleanProperty());
                break;
            }
            case BYTE: {
                dos.writeByte(this.getByteProperty());
                break;
            }
            case INT: {
                dos.writeInt(this.getIntProperty());
                break;
            }
            case LONG: {
                dos.writeLong(this.getLongProperty());
                break;
            }
            case FLOAT: {
                dos.writeFloat(this.getFloatProperty());
                break;
            }
            case DOUBLE: {
                dos.writeDouble(this.getDoubleProperty());
                break;
            }
            case STRING: {
                MessageUtils.writeString(dos, this.getStringProperty());
                break;
            }
            case BITSET: {
                MessageUtils.writeBitSet(dos, this.getBitSetProperty());
                break;
            }
            case BYTE_ARRAY: {
                MessageUtils.writeByteArray(dos, this.getByteArrayProperty());
                break;
            }
            case INT_ARRAY: {
                MessageUtils.writeIntArray(dos, this.getIntArrayProperty());
                break;
            }
            case LONG_ARRAY: {
                MessageUtils.writeLongArray(dos, this.getLongArrayProperty());
                break;
            }
            case FLOAT_ARRAY: {
                MessageUtils.writeFloatArray(dos, this.getFloatArrayProperty());
                break;
            }
            case DOUBLE_ARRAY: {
                MessageUtils.writeDoubleArray(dos, this.getDoubleArrayProperty());
                break;
            }
            case STRING_ARRAY: {
                MessageUtils.writeStringArray(dos, this.getStringArrayProperty());
                break;
            }
            case FILE: {
                MessageUtils.writeFileProperty(dos, this.getFileProperty(), fileSink);
                break;
            }
        }
    }

    @Override
    public void write(ByteBuf buf, FileSink fileSink) throws IOException {
        buf.writeByte(this.propertyDefinition.getType().getId());
        buf.writeShort(this.propertyDefinition.getKey());
        switch (this.propertyDefinition.getType()) {
            case OBJECT_SINGLE_REFERENCE: {
                MessageObject referencedObject = this.getReferencedObject();
                referencedObject.write(buf, fileSink);
                break;
            }
            case OBJECT_MULTI_REFERENCE: {
                List<MessageObject> referencedObjects = this.getReferencedObjects();
                if (referencedObjects == null || referencedObjects.isEmpty()) {
                    buf.writeInt(0);
                    break;
                }
                buf.writeInt(referencedObjects.size());
                for (MessageObject referencedObject : referencedObjects) {
                    referencedObject.write(buf, fileSink);
                }
                break;
            }
            case BOOLEAN: {
                buf.writeBoolean(this.getBooleanProperty());
                break;
            }
            case BYTE: {
                buf.writeByte((int)this.getByteProperty());
                break;
            }
            case INT: {
                buf.writeInt(this.getIntProperty());
                break;
            }
            case LONG: {
                buf.writeLong(this.getLongProperty());
                break;
            }
            case FLOAT: {
                buf.writeFloat(this.getFloatProperty());
                break;
            }
            case DOUBLE: {
                buf.writeDouble(this.getDoubleProperty());
                break;
            }
            case STRING: {
                MessageUtils.writeString(buf, this.getStringProperty());
                break;
            }
            case BYTE_ARRAY: {
                MessageUtils.writeByteArray(buf, this.getByteArrayProperty());
                break;
            }
            case FILE: {
                MessageUtils.writeFileProperty(buf, this.getFileProperty(), fileSink);
                break;
            }
        }
    }

    @Override
    public byte[] toBytes() throws IOException {
        return this.toBytes(null);
    }

    @Override
    public byte[] toBytes(FileSink fileSink) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.write(dos, fileSink);
        dos.close();
        return bos.toByteArray();
    }

    @Override
    public PropertyDefinition getPropertyDefinition() {
        return this.propertyDefinition;
    }

    @Override
    public MessageObject getReferencedObject() {
        if (this.value == null) {
            return null;
        }
        return (MessageObject)this.value;
    }

    @Override
    public List<MessageObject> getReferencedObjects() {
        if (this.value == null) {
            return null;
        }
        return (List)this.value;
    }

    @Override
    public <TYPE extends MessageObject> TYPE getReferencedObjectAsType() {
        if (this.value == null) {
            return null;
        }
        return (TYPE)((MessageObject)this.value);
    }

    @Override
    public <TYPE extends MessageObject> List<TYPE> getReferencedObjectsAsType() {
        if (this.value == null) {
            return null;
        }
        return (List)this.value;
    }

    @Override
    public boolean getBooleanProperty() {
        if (this.value == null) {
            return false;
        }
        return (Boolean)this.value;
    }

    @Override
    public byte getByteProperty() {
        if (this.value == null) {
            return 0;
        }
        return (Byte)this.value;
    }

    @Override
    public int getIntProperty() {
        if (this.value == null) {
            return 0;
        }
        return (Integer)this.value;
    }

    @Override
    public long getLongProperty() {
        if (this.value == null) {
            return 0L;
        }
        return (Long)this.value;
    }

    @Override
    public float getFloatProperty() {
        if (this.value == null) {
            return 0.0f;
        }
        return ((Float)this.value).floatValue();
    }

    @Override
    public double getDoubleProperty() {
        if (this.value == null) {
            return 0.0;
        }
        return (Double)this.value;
    }

    @Override
    public String getStringProperty() {
        if (this.value == null) {
            return null;
        }
        return (String)this.value;
    }

    @Override
    public FileProperty getFileProperty() {
        if (this.value == null) {
            return null;
        }
        return (FileProperty)this.value;
    }

    @Override
    public File getFilePropertyAsFile() {
        if (this.value == null) {
            return null;
        }
        return this.getFileProperty().getFile();
    }

    @Override
    public String getFilePropertyAsFileName() {
        if (this.value == null) {
            return null;
        }
        return this.getFileProperty().getFileName();
    }

    @Override
    public long getFilePropertyAsFileLength() {
        if (this.value == null) {
            return 0L;
        }
        return this.getFileProperty().getLength();
    }

    @Override
    public BitSet getBitSetProperty() {
        if (this.value == null) {
            return null;
        }
        return (BitSet)this.value;
    }

    @Override
    public byte[] getByteArrayProperty() {
        if (this.value == null) {
            return null;
        }
        return (byte[])this.value;
    }

    @Override
    public int[] getIntArrayProperty() {
        if (this.value == null) {
            return null;
        }
        return (int[])this.value;
    }

    @Override
    public long[] getLongArrayProperty() {
        if (this.value == null) {
            return null;
        }
        return (long[])this.value;
    }

    @Override
    public float[] getFloatArrayProperty() {
        if (this.value == null) {
            return null;
        }
        return (float[])this.value;
    }

    @Override
    public double[] getDoubleArrayProperty() {
        if (this.value == null) {
            return null;
        }
        return (double[])this.value;
    }

    @Override
    public String[] getStringArrayProperty() {
        if (this.value == null) {
            return null;
        }
        return (String[])this.value;
    }

    @Override
    public String getAsString() {
        return "" + this.value;
    }

    @Override
    public String explain(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t".repeat(level)).append(this.propertyDefinition.getName()).append(", ");
        if (this.propertyDefinition.getTitle() != null) {
            sb.append(this.propertyDefinition.getTitle()).append(", ");
        }
        sb.append((Object)this.propertyDefinition.getType());
        sb.append((String)(this.propertyDefinition.getContentType() != PropertyContentType.GENERIC ? ", " + this.propertyDefinition.getContentType() : ""));
        if (this.propertyDefinition.isReferenceProperty()) {
            ObjectPropertyDefinition referenceDefinition = this.propertyDefinition.getReferencedObject();
            if (this.propertyDefinition.isMultiReference()) {
                sb.append("\n");
                for (MessageObject referencedObject : this.getReferencedObjects()) {
                    sb.append(referencedObject.explain(level + 1)).append("\n");
                }
            } else {
                sb.append("\n");
                MessageObject referencedObject = this.getReferencedObject();
                sb.append(referencedObject.explain(level + 1));
            }
        } else {
            sb.append(": ").append(this.value);
        }
        return sb.toString();
    }

    public String toString() {
        return this.explain(0);
    }
}

