/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.protocol.schema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.IOUtils;
import org.teamapps.protocol.schema.MessageModel;
import org.teamapps.protocol.schema.ModelCollection;
import org.teamapps.protocol.schema.ObjectPropertyDefinition;
import org.teamapps.protocol.schema.PropertyDefinition;
import org.teamapps.protocol.schema.PropertyType;
import org.teamapps.protocol.schema.ProtocolServiceMethod;
import org.teamapps.protocol.schema.ProtocolServiceSchema;

public class MessagePojoBuilder {
    public static void createPojos(ModelCollection modelCollection, File directory) throws IOException {
        File dir = directory;
        String namespace = modelCollection.getNamespace();
        for (String name : namespace.split("\\.")) {
            dir = new File(dir, name);
            dir.mkdir();
        }
        System.out.println("Create source in path: " + dir.getPath());
        MessagePojoBuilder.createServiceClasses(modelCollection, dir);
        MessagePojoBuilder.createSchemaPojo(modelCollection, dir);
        for (MessageModel model : modelCollection.getModels()) {
            MessagePojoBuilder.createMessagePojoSave(modelCollection, model, dir);
        }
    }

    private static void createServiceClasses(ModelCollection modelCollection, File directory) throws IOException {
        for (ProtocolServiceSchema protocolServiceSchema : modelCollection.getProtocolServiceSchemas()) {
            String tpl = MessagePojoBuilder.readTemplate("protocolService.tpl");
            tpl = MessagePojoBuilder.setValue(tpl, "package", modelCollection.getNamespace());
            String type = "Abstract" + MessagePojoBuilder.firstUpperCase(protocolServiceSchema.getServiceName());
            tpl = MessagePojoBuilder.setValue(tpl, "type", type);
            tpl = MessagePojoBuilder.setValue(tpl, "serviceName", protocolServiceSchema.getServiceName());
            StringBuilder data = new StringBuilder();
            StringBuilder cases = new StringBuilder();
            for (ProtocolServiceMethod method : protocolServiceSchema.getServiceMethods()) {
                String inputMessageName = method.getInputMessage().getName();
                data.append(MessagePojoBuilder.getTabs(1)).append("public abstract ").append(MessagePojoBuilder.firstUpperCase(method.getOutputMessage().getName())).append(" ").append(method.getMethodName()).append("(").append(MessagePojoBuilder.firstUpperCase(inputMessageName)).append(" value);\n\n");
                cases.append(MessagePojoBuilder.getTabs(3)).append("case \"").append(method.getMethodName()).append("\" -> {\n");
                cases.append(MessagePojoBuilder.getTabs(4)).append("return ").append(method.getMethodName()).append("(").append(MessagePojoBuilder.firstUpperCase(inputMessageName)).append(".remap(request));\n");
                cases.append(MessagePojoBuilder.getTabs(3)).append("}\n");
            }
            tpl = MessagePojoBuilder.setValue(tpl, "methods", data.toString());
            tpl = MessagePojoBuilder.setValue(tpl, "cases", cases.toString());
            File file = new File(directory, type + ".java");
            Files.writeString(file.toPath(), (CharSequence)tpl, new OpenOption[0]);
            type = MessagePojoBuilder.firstUpperCase(protocolServiceSchema.getServiceName()) + "Client";
            tpl = MessagePojoBuilder.readTemplate("protocolServiceClient.tpl");
            tpl = MessagePojoBuilder.setValue(tpl, "package", modelCollection.getNamespace());
            tpl = MessagePojoBuilder.setValue(tpl, "type", type);
            tpl = MessagePojoBuilder.setValue(tpl, "serviceName", protocolServiceSchema.getServiceName());
            data = new StringBuilder();
            for (ProtocolServiceMethod method : protocolServiceSchema.getServiceMethods()) {
                String inputMessageName = method.getInputMessage().getObjectPropertyDefinition().getName();
                String outputMessageName = method.getOutputMessage().getObjectPropertyDefinition().getName();
                data.append(MessagePojoBuilder.getTabs(1)).append("public ").append(MessagePojoBuilder.firstUpperCase(outputMessageName)).append(" ").append(method.getMethodName()).append("(").append(MessagePojoBuilder.firstUpperCase(inputMessageName)).append(" value) {\n");
                data.append(MessagePojoBuilder.getTabs(2)).append("return executeClusterServiceMethod(\"").append(method.getMethodName()).append("\", value, ").append(MessagePojoBuilder.firstUpperCase(outputMessageName)).append(".getMessageDecoder());\n");
                data.append(MessagePojoBuilder.getTabs(1)).append("}\n\n");
            }
            tpl = MessagePojoBuilder.setValue(tpl, "methods", data.toString());
            file = new File(directory, type + ".java");
            Files.writeString(file.toPath(), (CharSequence)tpl, new OpenOption[0]);
        }
    }

    private static void createSchemaPojo(ModelCollection modelCollection, File directory) throws IOException {
        String objName;
        ObjectPropertyDefinition objDef;
        String tpl = MessagePojoBuilder.readTemplate("messageCollection.tpl");
        tpl = MessagePojoBuilder.setValue(tpl, "package", modelCollection.getNamespace());
        tpl = MessagePojoBuilder.setValue(tpl, "type", MessagePojoBuilder.firstUpperCase(modelCollection.getName()));
        tpl = MessagePojoBuilder.setValue(tpl, "version", "" + modelCollection.getVersion());
        tpl = MessagePojoBuilder.setValue(tpl, "name", modelCollection.getName());
        StringBuilder data = new StringBuilder();
        StringBuilder registry = new StringBuilder();
        for (MessageModel model : modelCollection.getModels()) {
            objDef = model.getObjectPropertyDefinition();
            objName = objDef.getName();
            data.append(MessagePojoBuilder.getTabs(2)).append("ObjectPropertyDefinition ").append(objName).append(" = MODEL_COLLECTION.createModel(").append(MessagePojoBuilder.withQuotes(objName)).append(", ").append(MessagePojoBuilder.withQuotes(objDef.getObjectUuid())).append(", ").append(model.getModelVersion()).append(", ").append(MessagePojoBuilder.withQuotes(objDef.getTitle())).append(", ").append(MessagePojoBuilder.withQuotes(objDef.getSpecificType())).append(");\n");
        }
        data.append("\n");
        for (MessageModel model : modelCollection.getModels()) {
            objDef = model.getObjectPropertyDefinition();
            objName = objDef.getName();
            for (PropertyDefinition propDef : model.getPropertyDefinitions()) {
                if (propDef.isReferenceProperty()) {
                    String method = propDef.getType() == PropertyType.OBJECT_SINGLE_REFERENCE ? "addSingleReference" : "addMultiReference";
                    data.append(MessagePojoBuilder.getTabs(2)).append(objName).append(".").append(method).append("(").append(MessagePojoBuilder.withQuotes(propDef.getName())).append(", ").append(propDef.getKey()).append(", ").append(MessagePojoBuilder.withQuotes(propDef.getSpecificType())).append(", ").append(MessagePojoBuilder.withQuotes(propDef.getTitle())).append(", ").append(propDef.getReferencedObject().getName()).append(");\n");
                    continue;
                }
                data.append(MessagePojoBuilder.getTabs(2)).append(objName).append(".addProperty(").append(MessagePojoBuilder.withQuotes(propDef.getName())).append(", ").append(propDef.getKey()).append(", ").append("PropertyType.").append((Object)propDef.getType()).append(", ").append("PropertyContentType.").append((Object)propDef.getContentType()).append(", ").append(MessagePojoBuilder.withQuotes(propDef.getSpecificType())).append(", ").append(MessagePojoBuilder.withQuotes(propDef.getTitle())).append(");\n");
            }
            data.append("\n");
            registry.append(MessagePojoBuilder.getTabs(2)).append("MODEL_COLLECTION.addMessageDecoder(").append(objName).append(".getObjectUuid(), ").append(MessagePojoBuilder.firstUpperCase(objName)).append(".getMessageDecoder());\n");
        }
        tpl = MessagePojoBuilder.setValue(tpl, "data", data.toString());
        tpl = MessagePojoBuilder.setValue(tpl, "registry", registry.toString());
        File file = new File(directory, MessagePojoBuilder.firstUpperCase(modelCollection.getName()) + ".java");
        Files.writeString(file.toPath(), (CharSequence)tpl, new OpenOption[0]);
    }

    private static void createMessagePojoSave(ModelCollection modelCollection, MessageModel field, File directory) {
        try {
            MessagePojoBuilder.createMessagePojo(modelCollection, field, directory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void createMessagePojo(ModelCollection modelCollection, MessageModel model, File directory) throws IOException {
        ObjectPropertyDefinition objDef = model.getObjectPropertyDefinition();
        String tpl = MessagePojoBuilder.readTemplate("messagePojo.tpl");
        tpl = MessagePojoBuilder.setValue(tpl, "package", modelCollection.getNamespace());
        tpl = MessagePojoBuilder.setValue(tpl, "type", MessagePojoBuilder.firstUpperCase(objDef.getName()));
        tpl = MessagePojoBuilder.setValue(tpl, "schema", MessagePojoBuilder.firstUpperCase(modelCollection.getName()));
        tpl = MessagePojoBuilder.setValue(tpl, "version", "" + model.getModelVersion());
        tpl = MessagePojoBuilder.setValue(tpl, "uuid", objDef.getObjectUuid());
        StringBuilder data = new StringBuilder();
        for (PropertyDefinition propDef : objDef.getPropertyDefinitions()) {
            String objectReferenceWithType = propDef.isReferenceProperty() ? "AsType" : "";
            data.append(MessagePojoBuilder.getTabs(1)).append("public ").append(MessagePojoBuilder.getReturnType(propDef)).append(" ").append(propDef.getType() == PropertyType.BOOLEAN ? "is" : "get").append(MessagePojoBuilder.firstUpperCase(propDef.getName())).append("() {\n").append(MessagePojoBuilder.getTabs(2)).append("return get").append(MessagePojoBuilder.getGetterSetterMethodName(propDef)).append(objectReferenceWithType).append("(").append(MessagePojoBuilder.withQuotes(propDef.getName())).append(");\n").append(MessagePojoBuilder.getTabs(1)).append("}\n\n");
            data.append(MessagePojoBuilder.getTabs(1)).append("public ").append(MessagePojoBuilder.firstUpperCase(objDef.getName())).append(" ").append("set").append(MessagePojoBuilder.firstUpperCase(propDef.getName())).append("(").append(MessagePojoBuilder.getReturnType(propDef)).append(" value) {\n").append(MessagePojoBuilder.getTabs(2)).append("set").append(MessagePojoBuilder.getGetterSetterMethodName(propDef)).append(objectReferenceWithType).append("(").append(MessagePojoBuilder.withQuotes(propDef.getName())).append(", value);\n").append(MessagePojoBuilder.getTabs(2)).append("return this;\n").append(MessagePojoBuilder.getTabs(1)).append("}\n\n");
            if (propDef.getType() == PropertyType.FILE) {
                data.append(MessagePojoBuilder.getTabs(1)).append("public File get").append(MessagePojoBuilder.firstUpperCase(propDef.getName())).append("AsFile").append("() {\n").append(MessagePojoBuilder.getTabs(2)).append("return get").append("FilePropertyAsFile").append("(").append(MessagePojoBuilder.withQuotes(propDef.getName())).append(");\n").append(MessagePojoBuilder.getTabs(1)).append("}\n\n");
                data.append(MessagePojoBuilder.getTabs(1)).append("public String get").append(MessagePojoBuilder.firstUpperCase(propDef.getName())).append("AsFileName").append("() {\n").append(MessagePojoBuilder.getTabs(2)).append("return get").append("FilePropertyAsFileName").append("(").append(MessagePojoBuilder.withQuotes(propDef.getName())).append(");\n").append(MessagePojoBuilder.getTabs(1)).append("}\n\n");
                data.append(MessagePojoBuilder.getTabs(1)).append("public long get").append(MessagePojoBuilder.firstUpperCase(propDef.getName())).append("AsFileLength").append("() {\n").append(MessagePojoBuilder.getTabs(2)).append("return get").append("FilePropertyAsFileLength").append("(").append(MessagePojoBuilder.withQuotes(propDef.getName())).append(");\n").append(MessagePojoBuilder.getTabs(1)).append("}\n\n");
                data.append(MessagePojoBuilder.getTabs(1)).append("public ").append(MessagePojoBuilder.firstUpperCase(objDef.getName())).append(" ").append("set").append(MessagePojoBuilder.firstUpperCase(propDef.getName())).append("(").append("File").append(" value) {\n").append(MessagePojoBuilder.getTabs(2)).append("set").append(MessagePojoBuilder.getGetterSetterMethodName(propDef)).append("(").append(MessagePojoBuilder.withQuotes(propDef.getName())).append(", value);\n").append(MessagePojoBuilder.getTabs(2)).append("return this;\n").append(MessagePojoBuilder.getTabs(1)).append("}\n\n");
            }
            if (propDef.getType() == PropertyType.OBJECT_MULTI_REFERENCE) {
                data.append(MessagePojoBuilder.getTabs(1)).append("public ").append(MessagePojoBuilder.firstUpperCase(objDef.getName())).append(" ").append("add").append(MessagePojoBuilder.firstUpperCase(propDef.getName())).append("(").append(MessagePojoBuilder.firstUpperCase(propDef.getReferencedObject().getName())).append(" value) {\n").append(MessagePojoBuilder.getTabs(2)).append("addReference").append("(").append(MessagePojoBuilder.withQuotes(propDef.getName())).append(", value);\n").append(MessagePojoBuilder.getTabs(2)).append("return this;\n").append(MessagePojoBuilder.getTabs(1)).append("}\n\n");
            }
            if (propDef.getType() != PropertyType.STRING_ARRAY) continue;
        }
        tpl = MessagePojoBuilder.setValue(tpl, "methods", data.toString());
        File file = new File(directory, MessagePojoBuilder.firstUpperCase(objDef.getName()) + ".java");
        Files.writeString(file.toPath(), (CharSequence)tpl, new OpenOption[0]);
        System.out.println("Write pojo:" + file.getPath());
    }

    private static String readTemplate(String name) throws IOException {
        InputStream inputStream = MessagePojoBuilder.class.getResourceAsStream("/templates/" + name);
        return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
    }

    private static String setValue(String template, String name, String value) {
        return template.replace("{" + name + "}", value);
    }

    private static String firstUpperCase(String value) {
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    private static String getTabs(int count) {
        return "\t".repeat(count);
    }

    private static String withQuotes(String value) {
        return value != null ? "\"" + value + "\"" : "null";
    }

    private static String getReturnType(PropertyDefinition propDef) {
        return switch (propDef.getType()) {
            case PropertyType.OBJECT -> MessagePojoBuilder.firstUpperCase(propDef.getName());
            case PropertyType.OBJECT_SINGLE_REFERENCE -> MessagePojoBuilder.firstUpperCase(propDef.getReferencedObject().getName());
            case PropertyType.OBJECT_MULTI_REFERENCE -> "List<" + MessagePojoBuilder.firstUpperCase(propDef.getReferencedObject().getName()) + ">";
            case PropertyType.BOOLEAN -> "boolean";
            case PropertyType.BYTE -> "byte";
            case PropertyType.INT -> "int";
            case PropertyType.LONG -> "long";
            case PropertyType.FLOAT -> "float";
            case PropertyType.DOUBLE -> "double";
            case PropertyType.STRING -> "String";
            case PropertyType.BITSET -> "BitSet";
            case PropertyType.BYTE_ARRAY -> "byte[]";
            case PropertyType.INT_ARRAY -> "int[]";
            case PropertyType.LONG_ARRAY -> "long[]";
            case PropertyType.FLOAT_ARRAY -> "float[]";
            case PropertyType.DOUBLE_ARRAY -> "double[]";
            case PropertyType.STRING_ARRAY -> "String[]";
            case PropertyType.FILE -> "FileProperty";
            case PropertyType.ENUM -> MessagePojoBuilder.firstUpperCase(propDef.getName());
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private static String getGetterSetterMethodName(PropertyDefinition propDef) {
        return switch (propDef.getType()) {
            case PropertyType.OBJECT -> "MessageObject";
            case PropertyType.OBJECT_SINGLE_REFERENCE -> "ReferencedObject";
            case PropertyType.OBJECT_MULTI_REFERENCE -> "ReferencedObjects";
            case PropertyType.BOOLEAN -> "BooleanProperty";
            case PropertyType.BYTE -> "ByteProperty";
            case PropertyType.INT -> "IntProperty";
            case PropertyType.LONG -> "LongProperty";
            case PropertyType.FLOAT -> "FloatProperty";
            case PropertyType.DOUBLE -> "DoubleProperty";
            case PropertyType.STRING -> "StringProperty";
            case PropertyType.BITSET -> "BitSetProperty";
            case PropertyType.BYTE_ARRAY -> "ByteArrayProperty";
            case PropertyType.INT_ARRAY -> "IntArrayProperty";
            case PropertyType.LONG_ARRAY -> "LongArrayProperty";
            case PropertyType.FLOAT_ARRAY -> "FloatArrayProperty";
            case PropertyType.DOUBLE_ARRAY -> "DoubleArrayProperty";
            case PropertyType.STRING_ARRAY -> "StringArrayProperty";
            case PropertyType.FILE -> "FileProperty";
            case PropertyType.ENUM -> "IntProperty";
            default -> throw new IncompatibleClassChangeError();
        };
    }
}

